/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.geo.LatLngRole;
import org.pentaho.agilebi.modeler.geo.LocationRole;
import org.pentaho.agilebi.modeler.nodes.annotations.GeoAnnotationFactory;
import org.pentaho.agilebi.modeler.nodes.annotations.MemberAnnotationFactory;

public class GeoContextFactory {
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";

    public static GeoContext create(GeoContextConfigProvider configProvider) throws ModelerException {
        String rolesCsv;
        GeoContext geo = new GeoContext();
        if (configProvider == null) {
            throw new IllegalArgumentException("GeoContextConfigProvider cannot be null");
        }
        String dimName = configProvider.getDimensionName();
        if (dimName != null && dimName.trim().length() > 0) {
            geo.dimensionName = dimName;
        }
        if ((rolesCsv = configProvider.getRoles()) != null && rolesCsv.length() > 0) {
            String[] tokens = rolesCsv.split(",");
            ArrayList<String> roleNames = new ArrayList<String>(tokens.length);
            for (String s : tokens) {
                roleNames.add(s.trim());
            }
            for (String rolename : roleNames) {
                GeoRole role;
                String aliases = configProvider.getRoleAliases(rolename);
                String parents = configProvider.getRoleRequirements(rolename);
                String displayName = ModelerMessagesHolder.getMessages().getString("geo." + rolename, new String[0]);
                if (StringUtils.isEmpty((String)displayName)) {
                    displayName = rolename;
                }
                if ((role = new GeoRole(rolename, displayName, aliases)) == null) continue;
                if (parents != null) {
                    List<String> requiredParents = GeoRole.parse(parents);
                    for (String parentRole : requiredParents) {
                        GeoRole pgr = geo.getGeoRoleByName(parentRole);
                        if (pgr == null) continue;
                        role.getRequiredParentRoles().add(pgr);
                    }
                }
                geo.add(role);
            }
        } else {
            throw new ModelerException("Error while building GeoContext: No GeoRoles found, make sure there is a geo.roles property defined.");
        }
        String latAliases = configProvider.getRoleAliases(LATITUDE);
        LatLngRole latRole = new LatLngRole(LATITUDE, latAliases);
        String longAliases = configProvider.getRoleAliases(LONGITUDE);
        LatLngRole longRole = new LatLngRole(LONGITUDE, longAliases);
        String displayName = ModelerMessagesHolder.getMessages().getString("geo.location", new String[0]);
        if (StringUtils.isEmpty((String)displayName)) {
            displayName = "location";
        }
        LocationRole locationRole = new LocationRole(latRole, displayName, longRole);
        geo.addGeoRole(locationRole);
        GeoAnnotationFactory fact = new GeoAnnotationFactory(geo);
        MemberAnnotationFactory.registerFactory("Geo.Role", fact);
        MemberAnnotationFactory.registerFactory("Data.Role", fact);
        MemberAnnotationFactory.registerFactory("Geo.RequiredParents", fact);
        return geo;
    }
}

