/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.tree;

import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.dialog.HadoopClusterDelegate;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.ui.spoon.SelectionTreeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionPoint(id="ThinHadoopClusterEditExtension", description="Edits named cluster", extensionPointId="SpoonViewTreeExtension")
public class ThinHadoopClusterEditExtension
implements ExtensionPointInterface {
    HadoopClusterDelegate hadoopClusterDelegate;
    private static final Logger logChannel = LoggerFactory.getLogger(ThinHadoopClusterEditExtension.class);

    public ThinHadoopClusterEditExtension(HadoopClusterDelegate hadoopClusterDelegate) {
        this.hadoopClusterDelegate = hadoopClusterDelegate;
    }

    public void callExtensionPoint(LogChannelInterface log, Object extension) throws KettleException {
        try {
            Object selection;
            SelectionTreeExtension selectionTreeExtension = (SelectionTreeExtension)extension;
            if (selectionTreeExtension.getAction().equals("EDIT_SELECTION_EXTENSION") && (selection = selectionTreeExtension.getSelection()) instanceof NamedCluster) {
                NamedCluster namedCluster = (NamedCluster)selection;
                String name = URLEncoder.encode(namedCluster.getName(), "UTF-8");
                this.hadoopClusterDelegate.openDialog("new-edit", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
            }
        }
        catch (UnsupportedEncodingException e) {
            logChannel.error(e.getMessage());
        }
    }
}

