/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.tree;

import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.dialog.HadoopClusterDelegate;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.HadoopClusterManager;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TreeSelection;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionPoint(id="HadoopClusterPopupMenuExtension", description="Creates popup menus for Hadoop clusters", extensionPointId="SpoonPopupMenuExtension")
public class HadoopClusterPopupMenuExtension
implements ExtensionPointInterface {
    private static final Class<?> PKG = HadoopClusterPopupMenuExtension.class;
    public static final String IMPORT_STATE = "import";
    public static final String NEW_EDIT_STATE = "new-edit";
    public static final String TESTING_STATE = "testing";
    public static final String ADD_DRIVER_STATE = "add-driver";
    public static final String DELETE_STATE = "delete";
    private static final int RESULT_YES = 0;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private Menu rootMenu;
    private Menu itemMenu;
    private HadoopClusterDelegate hadoopClusterDelegate;
    private NamedClusterService namedClusterService;
    private String internalShim;
    private static final Logger logChannel = LoggerFactory.getLogger(HadoopClusterPopupMenuExtension.class);
    private NamedCluster lastNamedCluster;

    public HadoopClusterPopupMenuExtension(HadoopClusterDelegate hadoopClusterDelegate, NamedClusterService namedClusterService, String internalShim) {
        this.hadoopClusterDelegate = hadoopClusterDelegate;
        this.namedClusterService = namedClusterService;
        this.internalShim = internalShim;
    }

    public void callExtensionPoint(LogChannelInterface log, Object extension) {
        Tree selectionTree = (Tree)extension;
        this.createNewPopupMenu(selectionTree);
    }

    private void createNewPopupMenu(Tree selectionTree) {
        Menu popupMenu = null;
        TreeSelection[] objects = this.spoonSupplier.get().getTreeObjects(selectionTree);
        if (objects.length != 1) {
            return;
        }
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        if (selection instanceof Class && selection.equals(NamedCluster.class)) {
            popupMenu = this.createRootPopupMenu(selectionTree);
        } else if (selection instanceof NamedCluster) {
            popupMenu = this.createMaintPopupMenu(selectionTree, (NamedCluster)selection);
        }
        if (popupMenu != null) {
            ConstUI.displayMenu((Menu)popupMenu, (Control)selectionTree);
        } else {
            selectionTree.setMenu(null);
        }
    }

    private Menu createRootPopupMenu(Tree tree) {
        if (!this.showAdminFunctions()) {
            return null;
        }
        if (this.rootMenu == null) {
            this.rootMenu = new Menu((Control)tree);
            this.createPopupMenuItem(this.rootMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.New", (String[])new String[0]), NEW_EDIT_STATE);
            this.createPopupMenuItem(this.rootMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Import", (String[])new String[0]), IMPORT_STATE);
            this.createPopupMenuItem(this.rootMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Add.Driver", (String[])new String[0]), ADD_DRIVER_STATE);
        }
        return this.rootMenu;
    }

    public Menu createMaintPopupMenu(Tree selectionTree, NamedCluster namedCluster) {
        if (this.itemMenu == null || !namedCluster.equals((Object)this.lastNamedCluster)) {
            this.lastNamedCluster = namedCluster;
            this.itemMenu = new Menu((Control)selectionTree);
            try {
                String name = URLEncoder.encode(namedCluster.getName(), "UTF-8");
                if (this.showAdminFunctions()) {
                    this.createPopupMenuItem(this.itemMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Edit", (String[])new String[0]), NEW_EDIT_STATE, (Map)ImmutableMap.of((Object)"name", (Object)name));
                    this.createPopupMenuItem(this.itemMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Duplicate", (String[])new String[0]), NEW_EDIT_STATE, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"duplicateName", (Object)(BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.Duplicate.Prefix", (String[])new String[0]) + name)));
                }
                this.createPopupMenuItem(this.itemMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Test", (String[])new String[0]), TESTING_STATE, (Map)ImmutableMap.of((Object)"name", (Object)name));
                if (this.showAdminFunctions()) {
                    this.createDeleteMenuItem(this.itemMenu, BaseMessages.getString(PKG, (String)"HadoopClusterPopupMenuExtension.MenuItem.Delete", (String[])new String[0]), name);
                }
            }
            catch (UnsupportedEncodingException e) {
                logChannel.error(e.getMessage());
            }
        }
        return this.itemMenu;
    }

    private boolean showAdminFunctions() {
        Repository repo = this.spoonSupplier.get().getRepository();
        if (repo != null && repo.getUri().isPresent()) {
            return repo.getSecurityProvider().getUserInfo().isAdmin();
        }
        return true;
    }

    private void createPopupMenuItem(Menu menu, String menuItemLabel, String state) {
        this.createPopupMenuItem(menu, menuItemLabel, state, Collections.emptyMap());
    }

    private void createPopupMenuItem(Menu menu, String menuItemLabel, final String state, final Map urlParams) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(menuItemLabel);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HadoopClusterPopupMenuExtension.this.hadoopClusterDelegate.openDialog(state, urlParams);
            }
        });
    }

    private void createDeleteMenuItem(Menu menu, String menuItemLabel, final String namedCluster) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(menuItemLabel);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    String nCluster = URLDecoder.decode(namedCluster, "UTF-8");
                    String title = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Title", (String[])new String[0]);
                    String message = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Message", (String[])new String[]{nCluster});
                    String deleteButton = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.Delete", (String[])new String[0]);
                    String doNotDeleteButton = BaseMessages.getString((Class)PKG, (String)"PopupMenuFactory.NAMEDCLUSTERS.DeleteNamedClusterAsk.DoNotDelete", (String[])new String[0]);
                    MessageDialog dialog = new MessageDialog(((Spoon)HadoopClusterPopupMenuExtension.this.spoonSupplier.get()).getShell(), title, null, message, 4, new String[]{deleteButton, doNotDeleteButton}, 0);
                    int response = dialog.open();
                    if (response != 0) {
                        return;
                    }
                    HadoopClusterManager hadoopClusterManager = new HadoopClusterManager((Spoon)HadoopClusterPopupMenuExtension.this.spoonSupplier.get(), HadoopClusterPopupMenuExtension.this.namedClusterService, (IMetaStore)((Spoon)HadoopClusterPopupMenuExtension.this.spoonSupplier.get()).getMetaStore(), HadoopClusterPopupMenuExtension.this.internalShim);
                    hadoopClusterManager.deleteNamedCluster((IMetaStore)((Spoon)HadoopClusterPopupMenuExtension.this.spoonSupplier.get()).getMetaStore(), nCluster, true);
                }
                catch (UnsupportedEncodingException e) {
                    logChannel.error(e.getMessage());
                }
            }
        });
    }
}

