/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONObject;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.dialog.HadoopClusterDialog;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.CachedFileItemStream;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.Category;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.Test;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.TestCategory;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.model.ThinNameClusterModel;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.NamedClusterSiteFile;
import org.pentaho.di.core.osgi.impl.NamedClusterSiteFileImpl;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.core.ShimIdentifierInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.RuntimeTestProgressCallback;
import org.pentaho.runtime.test.RuntimeTestStatus;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.module.RuntimeTestModuleResults;
import org.pentaho.runtime.test.result.RuntimeTestResult;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HadoopClusterManager
implements RuntimeTestProgressCallback {
    private static final Class<?> PKG = HadoopClusterDialog.class;
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(PKG, (String)"HadoopClusterTree.Title", (String[])new String[0]);
    public static final String PLACEHOLDER_VALUE = "[object Object]";
    private final String fileSeparator = System.getProperty("file.separator");
    private static final String PASS = "Pass";
    private static final String WARNING = "Warning";
    private static final String FAIL = "Fail";
    private static final String NAMED_CLUSTER = "namedCluster";
    private static final String INSTALLED = "installed";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String KEYTAB_AUTH_FILE = "keytabAuthFile";
    private static final String KEYTAB_IMPL_FILE = "keytabImpFile";
    public static final String MAPR_SHIM = "Map-R";
    public static final String MAPRFS_SCHEME = "maprfs";
    private static final LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)"HadoopClusterManager");
    private final String internalShim;
    private static final String KERBEROS_AUTHENTICATION_USERNAME = "pentaho.authentication.default.kerberos.principal";
    private static final String KERBEROS_AUTHENTICATION_PASS = "pentaho.authentication.default.kerberos.password";
    private static final String KERBEROS_IMPERSONATION_USERNAME = "pentaho.authentication.default.mapping.server.credentials.kerberos.principal";
    private static final String KERBEROS_IMPERSONATION_PASS = "pentaho.authentication.default.mapping.server.credentials.kerberos.password";
    private static final String IMPERSONATION = "pentaho.authentication.default.mapping.impersonation.type";
    private static final String KEYTAB_AUTHENTICATION_LOCATION = "pentaho.authentication.default.kerberos.keytabLocation";
    private static final String KEYTAB_IMPERSONATION_LOCATION = "pentaho.authentication.default.mapping.server.credentials.kerberos.keytabLocation";
    @VisibleForTesting
    Supplier<List<ShimIdentifierInterface>> shimIdentifiersSupplier = () -> PentahoSystem.getAll(ShimIdentifierInterface.class);
    private final Spoon spoon;
    private final NamedClusterService namedClusterService;
    private final IMetaStore metaStore;
    private final VariableSpace variableSpace;
    private RuntimeTestStatus runtimeTestStatus = null;

    public HadoopClusterManager(Spoon spoon, NamedClusterService namedClusterService, IMetaStore metaStore, String internalShim) {
        this.spoon = spoon;
        this.namedClusterService = namedClusterService;
        this.metaStore = metaStore != null ? metaStore : spoon.getMetaStore();
        this.variableSpace = spoon == null ? new Variables() : (AbstractMeta)spoon.getActiveMeta();
        this.internalShim = internalShim;
    }

    public JSONObject importNamedCluster(ThinNameClusterModel model, Map<String, CachedFileItemStream> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            NamedCluster nc = this.namedClusterService.getClusterTemplate();
            nc.setHdfsHost("");
            nc.setHdfsPort("");
            nc.setJobTrackerHost("");
            nc.setJobTrackerPort("");
            nc.setZooKeeperHost("");
            nc.setZooKeeperPort("");
            nc.setOozieUrl("");
            nc.setName(model.getName());
            nc.setHdfsUsername(model.getHdfsUsername());
            nc.setHdfsPassword(nc.encodePassword(model.getHdfsPassword()));
            if (MAPR_SHIM.equals(model.getShimVendor())) {
                nc.setStorageScheme(MAPRFS_SCHEME);
            }
            if (this.variableSpace != null) {
                nc.shareVariablesWith(this.variableSpace);
            } else {
                nc.initializeVariablesFrom(null);
            }
            boolean isConfigurationSet = this.configureNamedCluster(siteFilesSource, nc, model.getShimVendor(), model.getShimVersion());
            if (isConfigurationSet) {
                this.deleteNamedClusterSchemaOnly(model);
                this.setupKnoxSecurity(nc, model);
                this.deleteConfigFolder(nc.getName());
                this.installSiteFiles(siteFilesSource, nc);
                this.namedClusterService.create(nc, this.metaStore);
                this.createConfigProperties(nc);
                this.setupKerberosSecurity(model, siteFilesSource, "", "");
                response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
            }
        }
        catch (Exception e) {
            log.logError(e.getMessage());
        }
        return response;
    }

    private void deleteNamedClusterSchemaOnly(ThinNameClusterModel model) throws MetaStoreException {
        List existingNcNames = this.namedClusterService.listNames(this.metaStore);
        for (String existingNcName : existingNcNames) {
            if (!existingNcName.equalsIgnoreCase(model.getName())) continue;
            this.namedClusterService.delete(existingNcName, this.metaStore);
        }
    }

    private NamedCluster convertToNamedCluster(ThinNameClusterModel model) {
        NamedCluster nc = this.namedClusterService.getClusterTemplate();
        nc.setName(model.getName());
        nc.setHdfsHost(model.getHdfsHost());
        nc.setHdfsPort(model.getHdfsPort());
        nc.setHdfsUsername(model.getHdfsUsername());
        nc.setHdfsPassword(nc.encodePassword(model.getHdfsPassword()));
        nc.setJobTrackerHost(model.getJobTrackerHost());
        nc.setJobTrackerPort(model.getJobTrackerPort());
        nc.setZooKeeperHost(model.getZooKeeperHost());
        nc.setZooKeeperPort(model.getZooKeeperPort());
        nc.setOozieUrl(model.getOozieUrl());
        nc.setKafkaBootstrapServers(model.getKafkaBootstrapServers());
        this.resolveShimIdentifier(nc, model.getShimVendor(), model.getShimVersion());
        if (MAPR_SHIM.equals(model.getShimVendor())) {
            nc.setStorageScheme(MAPRFS_SCHEME);
        }
        this.setupKnoxSecurity(nc, model);
        if (this.variableSpace != null) {
            nc.shareVariablesWith(this.variableSpace);
        } else {
            nc.initializeVariablesFrom(null);
        }
        return nc;
    }

    private void deleteConfigFolder(String configFolderName) throws IOException {
        File configFolder = new File(this.getNamedClusterConfigsRootDir());
        File[] files = configFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().equalsIgnoreCase(configFolderName)) continue;
                FileUtils.deleteDirectory((File)file);
                break;
            }
        }
    }

    public JSONObject createNamedCluster(ThinNameClusterModel model, Map<String, CachedFileItemStream> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            NamedCluster nc = this.convertToNamedCluster(model);
            this.installSiteFiles(siteFilesSource, nc);
            this.namedClusterService.create(nc, this.metaStore);
            this.deleteConfigFolder(nc.getName());
            this.createConfigProperties(nc);
            this.setupKerberosSecurity(model, siteFilesSource, "", "");
            response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
        }
        catch (Exception e) {
            log.logError(e.getMessage());
        }
        return response;
    }

    public JSONObject editNamedCluster(ThinNameClusterModel model, boolean isEditMode, Map<String, CachedFileItemStream> siteFilesSource) {
        JSONObject response = new JSONObject();
        response.put((Object)NAMED_CLUSTER, (Object)"");
        try {
            NamedCluster newNc = this.namedClusterService.getNamedClusterByName(model.getName(), this.metaStore);
            NamedCluster oldNc = this.namedClusterService.getNamedClusterByName(model.getOldName(), this.metaStore);
            String shimId = oldNc.getShimIdentifier();
            List existingSiteFiles = oldNc.getSiteFiles();
            NamedCluster nc = this.convertToNamedCluster(model);
            nc.setSiteFiles(this.getIntersectionSiteFiles(model, existingSiteFiles));
            this.installSiteFiles(siteFilesSource, nc);
            if (newNc != null) {
                this.namedClusterService.update(nc, this.metaStore);
            } else {
                this.namedClusterService.create(nc, this.metaStore);
            }
            File oldConfigFolder = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + model.getOldName());
            File newConfigFolder = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName());
            if (!oldConfigFolder.getName().equalsIgnoreCase(newConfigFolder.getName())) {
                this.deleteConfigFolder(nc.getName());
                FileUtils.copyDirectory((File)oldConfigFolder, (File)newConfigFolder);
            } else {
                boolean success = oldConfigFolder.renameTo(newConfigFolder);
                if (!success) {
                    log.logError("Renaming Named Cluster configuration folder failed.");
                }
            }
            String keytabAuthenticationLocation = "";
            String keytabImpersonationLocation = "";
            String kerberosSubType = model.getKerberosSubType();
            if (!kerberosSubType.equals(KERBEROS_SUBTYPE.PASSWORD.getValue())) {
                String configFile = this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + CONFIG_PROPERTIES;
                PropertiesConfiguration config = new PropertiesConfiguration(new File(configFile));
                keytabAuthenticationLocation = (String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION);
                keytabImpersonationLocation = (String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION);
            }
            if (nc.getShimIdentifier() != null && !nc.getShimIdentifier().equals(shimId)) {
                this.createConfigProperties(nc);
            }
            this.setupKerberosSecurity(model, siteFilesSource, keytabAuthenticationLocation, keytabImpersonationLocation);
            if (isEditMode && !oldConfigFolder.getName().equalsIgnoreCase(newConfigFolder.getName())) {
                this.deleteNamedCluster(this.metaStore, model.getOldName(), false);
            }
            response.put((Object)NAMED_CLUSTER, (Object)nc.getName());
        }
        catch (Exception e) {
            log.logError(e.getMessage());
        }
        return response;
    }

    public ThinNameClusterModel getNamedCluster(String namedCluster) {
        ThinNameClusterModel model = null;
        try {
            List namedClusters = this.namedClusterService.list(this.metaStore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equalsIgnoreCase(namedCluster)) continue;
                model = new ThinNameClusterModel();
                model.setName(nc.getName());
                model.setHdfsHost(nc.getHdfsHost());
                model.setHdfsUsername(nc.getHdfsUsername());
                model.setHdfsPassword(nc.decodePassword(nc.getHdfsPassword()));
                model.setHdfsPort(nc.getHdfsPort());
                model.setJobTrackerHost(nc.getJobTrackerHost());
                model.setJobTrackerPort(nc.getJobTrackerPort());
                model.setKafkaBootstrapServers(nc.getKafkaBootstrapServers());
                model.setOozieUrl(nc.getOozieUrl());
                model.setZooKeeperPort(nc.getZooKeeperPort());
                model.setZooKeeperHost(nc.getZooKeeperHost());
                this.resolveShimVendorAndVersion(model, nc.getShimIdentifier());
                model.setGatewayPassword(nc.decodePassword(nc.getGatewayPassword()));
                model.setGatewayUrl(nc.getGatewayUrl());
                model.setGatewayUsername(nc.getGatewayUsername());
                model.setSecurityType(SECURITY_TYPE.NONE.getValue());
                if (nc.isUseGateway()) {
                    model.setSecurityType(SECURITY_TYPE.KNOX.getValue());
                } else {
                    this.resolveKerberosSecurity(model, nc);
                }
                model.setSiteFiles(nc.getSiteFiles().stream().map(sf -> new AbstractMap.SimpleImmutableEntry<String, String>("name", sf.getSiteFileName())).collect(Collectors.toList()));
                break;
            }
        }
        catch (MetaStoreException e) {
            log.logError(e.getMessage());
        }
        return model;
    }

    private boolean configureNamedCluster(Map<String, CachedFileItemStream> siteFilesSource, NamedCluster nc, String shimVendor, String shimVersion) {
        String oozieAddress;
        this.resolveShimIdentifier(nc, shimVendor, shimVersion);
        String oozieBaseUrl = "oozie.base.url";
        HashMap<String, String> properties = new HashMap<String, String>();
        this.extractProperties(siteFilesSource, "core-site.xml", properties, new String[]{"fs.defaultFS"});
        this.extractProperties(siteFilesSource, "yarn-site.xml", properties, new String[]{"yarn.resourcemanager.address", "yarn.resourcemanager.hostname"});
        this.extractProperties(siteFilesSource, "hive-site.xml", properties, new String[]{"hive.zookeeper.quorum", "hive.zookeeper.client.port"});
        this.extractProperties(siteFilesSource, "oozie-site.xml", properties, new String[]{oozieBaseUrl});
        if (properties.get(oozieBaseUrl) == null) {
            this.extractProperties(siteFilesSource, "oozie-default.xml", properties, new String[]{oozieBaseUrl});
        }
        boolean isConfigurationSet = false;
        String hdfsAddress = (String)properties.get("fs.defaultFS");
        if (hdfsAddress != null) {
            URI hdfsURL = URI.create(hdfsAddress);
            nc.setHdfsHost(hdfsURL.getHost());
            nc.setHdfsPort(hdfsURL.getPort() != -1 ? hdfsURL.getPort() + "" : "");
            isConfigurationSet = true;
        }
        String jobTrackerAddress = (String)properties.get("yarn.resourcemanager.address");
        String jobTrackerHostname = (String)properties.get("yarn.resourcemanager.hostname");
        if (jobTrackerAddress != null) {
            Map<String, String> hostAndPort = this.extractHostAndPort(jobTrackerAddress);
            nc.setJobTrackerHost(hostAndPort.get("host"));
            nc.setJobTrackerPort(hostAndPort.get("port"));
            isConfigurationSet = true;
        } else if (jobTrackerHostname != null) {
            nc.setJobTrackerHost(jobTrackerHostname);
            isConfigurationSet = true;
        }
        String zooKeeperAddress = (String)properties.get("hive.zookeeper.quorum");
        String zooKeeperPort = (String)properties.get("hive.zookeeper.client.port");
        if (zooKeeperAddress != null) {
            List<String> addresses = Arrays.asList(zooKeeperAddress.split(","));
            List hostNames = addresses.stream().map(address -> this.extractHostAndPort((String)address).get("host")).collect(Collectors.toList());
            zooKeeperAddress = String.join((CharSequence)",", hostNames);
        }
        if (zooKeeperAddress != null && zooKeeperPort != null) {
            nc.setZooKeeperHost(zooKeeperAddress);
            nc.setZooKeeperPort(zooKeeperPort);
            isConfigurationSet = true;
        }
        if ((oozieAddress = (String)properties.get(oozieBaseUrl)) != null) {
            nc.setOozieUrl(oozieAddress);
            isConfigurationSet = true;
        }
        return isConfigurationSet;
    }

    private void resolveShimIdentifier(NamedCluster nc, String shimVendor, String shimVersion) {
        List<ShimIdentifierInterface> shims = this.getShimIdentifiers();
        for (ShimIdentifierInterface shim : shims) {
            if (!shim.getVendor().equals(shimVendor) || !shim.getVersion().equals(shimVersion)) continue;
            nc.setShimIdentifier(shim.getId());
        }
    }

    private void resolveShimVendorAndVersion(ThinNameClusterModel model, String shimIdentifier) {
        List<ShimIdentifierInterface> shims = this.getShimIdentifiers();
        for (ShimIdentifierInterface shim : shims) {
            if (!shim.getId().equals(shimIdentifier)) continue;
            model.setShimVersion(shim.getVersion());
            model.setShimVendor(shim.getVendor());
        }
    }

    private void extractProperties(Map<String, CachedFileItemStream> siteFilesSource, String fileName, Map<String, String> properties, String[] keys) {
        Document document;
        CachedFileItemStream siteFile = siteFilesSource.get(fileName);
        if (siteFile != null && (document = this.parseSiteFileDocument(siteFile)) != null) {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            for (String key : keys) {
                try {
                    XPathExpression expr = xpath.compile("/configuration/property[name[starts-with(.,'" + key + "')]]/value/text()");
                    NodeList nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
                    if (nodes.getLength() <= 0) continue;
                    properties.put(key, nodes.item(0).getNodeValue());
                }
                catch (XPathExpressionException e) {
                    log.logMinimal(e.getMessage());
                }
            }
        }
    }

    public JSONObject installDriver(FileItemStream driver) {
        boolean success = false;
        if (driver != null) {
            String destination = Const.getShimDriverDeploymentLocation();
            try (InputStream driverStream = driver.openStream();){
                FileUtils.copyInputStreamToFile((InputStream)driverStream, (File)new File(destination + this.fileSeparator + driver.getFieldName()));
                success = true;
            }
            catch (IOException e) {
                log.logError(e.getMessage());
            }
        }
        JSONObject response = new JSONObject();
        response.put((Object)INSTALLED, (Object)success);
        return response;
    }

    private List<NamedClusterSiteFile> getIntersectionSiteFiles(ThinNameClusterModel model, List<NamedClusterSiteFile> existingSiteFiles) {
        List newSiteFileNames = Optional.ofNullable(model.getSiteFiles()).map(Collection::stream).orElseGet(Stream::empty).map(AbstractMap.SimpleImmutableEntry::getValue).collect(Collectors.toList());
        return existingSiteFiles.stream().filter(siteFile -> newSiteFileNames.contains(siteFile.getSiteFileName())).collect(Collectors.toList());
    }

    private void installSiteFiles(Map<String, CachedFileItemStream> siteFileSource, NamedCluster nc) throws IOException {
        for (Map.Entry<String, CachedFileItemStream> siteFile : siteFileSource.entrySet()) {
            String name = siteFile.getValue().getFieldName();
            if (!this.isValidConfigurationFile(name)) continue;
            if (name.equals(KEYTAB_AUTH_FILE) || name.equals(KEYTAB_IMPL_FILE) || !name.endsWith("-site.xml")) {
                name = this.extractFileNameFromFullPath(siteFile.getValue().getName());
                this.addFileToConfigFolder(siteFile.getValue().getCachedOutputStream(), name, nc);
                continue;
            }
            this.addFileToNamedClusterSiteFiles(siteFile, name, nc);
        }
    }

    private void addFileToConfigFolder(ByteArrayOutputStream outputStream, String fileName, NamedCluster nc) throws IOException {
        File destination = new File(this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + fileName);
        destination.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(destination);){
            outputStream.writeTo(fos);
        }
    }

    private void addFileToNamedClusterSiteFiles(Map.Entry<String, CachedFileItemStream> cachedFileItemStreamMapEntry, String fileName, NamedCluster nc) throws IOException {
        String str;
        ByteArrayInputStream inputStream = cachedFileItemStreamMapEntry.getValue().getCachedInputStream();
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        if (!sb.toString().equals(PLACEHOLDER_VALUE)) {
            boolean nameExists = false;
            for (NamedClusterSiteFile siteFile : nc.getSiteFiles()) {
                if (!siteFile.getSiteFileName().equals(fileName)) continue;
                siteFile.setSiteFileContents(sb.toString());
                nameExists = true;
                break;
            }
            if (!nameExists) {
                nc.addSiteFile((NamedClusterSiteFile)new NamedClusterSiteFileImpl(fileName, cachedFileItemStreamMapEntry.getValue().getLastModified(), sb.toString()));
            }
        }
    }

    public boolean isValidConfigurationFile(String fileName) {
        return fileName != null && (fileName.endsWith("-site.xml") || fileName.endsWith("-default.xml") || fileName.equals(CONFIG_PROPERTIES) || fileName.equals(KEYTAB_AUTH_FILE) || fileName.equals(KEYTAB_IMPL_FILE) || fileName.equals("data"));
    }

    private Document parseSiteFileDocument(CachedFileItemStream file) {
        Document document = null;
        try {
            document = XMLHandler.loadXMLFile((InputStream)file.getCachedInputStream());
        }
        catch (KettleXMLException e) {
            log.logMinimal(String.format("Site file %s is not a well formed XML document", file.getName()));
        }
        return document;
    }

    private void createConfigProperties(NamedCluster namedCluster) throws IOException {
        Path clusterConfigDirPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedCluster.getName(), new String[0]);
        Path configPropertiesPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedCluster.getName() + this.fileSeparator + CONFIG_PROPERTIES, new String[0]);
        Files.createDirectories(clusterConfigDirPath, new FileAttribute[0]);
        String sampleConfigProperties = namedCluster.getShimIdentifier() + "sampleconfig.properties";
        InputStream inputStream = HadoopClusterDelegateImpl.class.getClassLoader().getResourceAsStream(sampleConfigProperties);
        if (inputStream != null) {
            Files.copy(inputStream, configPropertiesPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void setupKerberosSecurity(ThinNameClusterModel model, Map<String, CachedFileItemStream> siteFilesSource, String keytabAuthenticationLocation, String keytabImpersonationLocation) {
        Path configPropertiesPath = Paths.get(this.getNamedClusterConfigsRootDir() + this.fileSeparator + model.getName() + this.fileSeparator + CONFIG_PROPERTIES, new String[0]);
        String securityType = model.getSecurityType();
        if (!StringUtil.isEmpty((String)securityType)) {
            this.resetKerberosSecurity(configPropertiesPath);
            if (securityType.equals(SECURITY_TYPE.KERBEROS.getValue())) {
                String kerberosSubType = model.getKerberosSubType();
                if (kerberosSubType.equals(KERBEROS_SUBTYPE.PASSWORD.getValue())) {
                    this.setupKerberosPasswordSecurity(configPropertiesPath, model);
                }
                if (kerberosSubType.equals(KERBEROS_SUBTYPE.KEYTAB.getValue())) {
                    this.setupKeytabSecurity(model, configPropertiesPath, siteFilesSource, keytabAuthenticationLocation, keytabImpersonationLocation);
                }
            }
        }
    }

    private void resetKerberosSecurity(Path configPropertiesPath) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KEYTAB_AUTHENTICATION_LOCATION, (Object)"");
            config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)"");
            config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)"");
            config.setProperty(KERBEROS_AUTHENTICATION_PASS, (Object)"");
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)"");
            config.setProperty(KERBEROS_IMPERSONATION_PASS, (Object)"");
            config.save();
        }
        catch (ConfigurationException e) {
            log.logMinimal(e.getMessage());
        }
    }

    private void resolveKerberosSecurity(ThinNameClusterModel model, NamedCluster nc) {
        try {
            String configFile = this.getNamedClusterConfigsRootDir() + this.fileSeparator + nc.getName() + this.fileSeparator + CONFIG_PROPERTIES;
            PropertiesConfiguration config = new PropertiesConfiguration(new File(configFile));
            model.setKerberosAuthenticationUsername((String)config.getProperty(KERBEROS_AUTHENTICATION_USERNAME));
            model.setKerberosAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)((String)config.getProperty(KERBEROS_AUTHENTICATION_PASS))));
            model.setKerberosImpersonationUsername((String)config.getProperty(KERBEROS_IMPERSONATION_USERNAME));
            String impersonationPasswordValue = Encr.decryptPasswordOptionallyEncrypted((String)((String)config.getProperty(KERBEROS_IMPERSONATION_PASS)));
            if ("Encrypted".equals(impersonationPasswordValue)) {
                impersonationPasswordValue = "";
            }
            model.setKerberosImpersonationPassword(impersonationPasswordValue);
            String keytabAuthenticationLocation = (String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION);
            String keytabImpersonationLocation = (String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION);
            if (!StringUtil.isEmpty((String)keytabAuthenticationLocation)) {
                String keytabAuthFile = keytabAuthenticationLocation.substring(keytabAuthenticationLocation.lastIndexOf(this.fileSeparator) + 1);
                model.setKeytabAuthFile(keytabAuthFile);
            }
            if (!StringUtil.isEmpty((String)keytabImpersonationLocation)) {
                String keytabImpFile = keytabImpersonationLocation.substring(keytabImpersonationLocation.lastIndexOf(this.fileSeparator) + 1);
                model.setKeytabImpFile(keytabImpFile);
            }
            if (StringUtil.isEmpty((String)keytabAuthenticationLocation) && StringUtil.isEmpty((String)keytabImpersonationLocation) && StringUtil.isEmpty((String)model.getKerberosAuthenticationPassword()) && StringUtil.isEmpty((String)model.getKerberosImpersonationPassword())) {
                model.setSecurityType(SECURITY_TYPE.NONE.getValue());
            } else {
                model.setSecurityType(SECURITY_TYPE.KERBEROS.getValue());
            }
            if (StringUtil.isEmpty((String)keytabAuthenticationLocation) && StringUtil.isEmpty((String)keytabImpersonationLocation)) {
                model.setKerberosSubType(KERBEROS_SUBTYPE.PASSWORD.getValue());
            } else {
                model.setKerberosSubType(KERBEROS_SUBTYPE.KEYTAB.getValue());
            }
        }
        catch (ConfigurationException e) {
            log.logError(e.getMessage());
        }
    }

    private void setupKerberosPasswordSecurity(Path configPropertiesPath, ThinNameClusterModel model) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)model.getKerberosAuthenticationUsername());
            if (!StringUtil.isEmpty((String)model.getKerberosAuthenticationPassword())) {
                config.setProperty(KERBEROS_AUTHENTICATION_PASS, (Object)Encr.encryptPasswordIfNotUsingVariables((String)model.getKerberosAuthenticationPassword()));
            } else {
                config.setProperty(KERBEROS_AUTHENTICATION_PASS, (Object)"");
            }
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)model.getKerberosImpersonationUsername());
            if (!StringUtil.isEmpty((String)model.getKerberosImpersonationPassword())) {
                config.setProperty(KERBEROS_IMPERSONATION_PASS, (Object)Encr.encryptPasswordIfNotUsingVariables((String)model.getKerberosImpersonationPassword()));
            } else {
                config.setProperty(KERBEROS_IMPERSONATION_PASS, (Object)"");
            }
            if (!StringUtil.isEmpty((String)model.getKerberosImpersonationUsername()) && !StringUtil.isEmpty((String)model.getKerberosImpersonationPassword()) || !StringUtil.isEmpty((String)model.getKerberosAuthenticationUsername()) && !StringUtil.isEmpty((String)model.getKerberosAuthenticationPassword())) {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.SIMPLE.getValue());
            } else {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            log.logMinimal(e.getMessage());
        }
    }

    private String extractFileNameFromFullPath(String fileName) {
        int lastIndex = fileName.lastIndexOf(47) != -1 ? fileName.lastIndexOf(47) : fileName.lastIndexOf(92);
        lastIndex = lastIndex == -1 ? 0 : lastIndex + 1;
        fileName = fileName.substring(lastIndex);
        return fileName;
    }

    private void setupKeytabSecurity(ThinNameClusterModel model, Path configPropertiesPath, Map<String, CachedFileItemStream> siteFilesSource, String keytabAuthenticationLocation, String keytabImpersonationLocation) {
        String name;
        String namedClusterName = model.getName();
        CachedFileItemStream keytabAuthFile = siteFilesSource.get(KEYTAB_AUTH_FILE);
        CachedFileItemStream keytabImpFile = siteFilesSource.get(KEYTAB_IMPL_FILE);
        String authenticationLocation = keytabAuthenticationLocation;
        String impersonationLocation = keytabImpersonationLocation;
        if (keytabAuthFile != null) {
            name = this.extractFileNameFromFullPath(keytabAuthFile.getName());
            authenticationLocation = this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedClusterName + this.fileSeparator + name;
        }
        if (keytabImpFile != null) {
            name = this.extractFileNameFromFullPath(keytabImpFile.getName());
            impersonationLocation = this.getNamedClusterConfigsRootDir() + this.fileSeparator + namedClusterName + this.fileSeparator + name;
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configPropertiesPath.toFile());
            config.setProperty(KERBEROS_AUTHENTICATION_USERNAME, (Object)model.getKerberosAuthenticationUsername());
            if (!StringUtil.isEmpty((String)authenticationLocation)) {
                config.setProperty(KEYTAB_AUTHENTICATION_LOCATION, (Object)authenticationLocation);
            }
            config.setProperty(KERBEROS_IMPERSONATION_USERNAME, (Object)model.getKerberosImpersonationUsername());
            if (keytabImpFile == null && StringUtil.isEmpty((String)model.getKeytabImpFile())) {
                config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)"");
            } else if (!StringUtil.isEmpty((String)impersonationLocation)) {
                config.setProperty(KEYTAB_IMPERSONATION_LOCATION, (Object)impersonationLocation);
            }
            if (!StringUtil.isEmpty((String)((String)config.getProperty(KEYTAB_AUTHENTICATION_LOCATION))) || !StringUtil.isEmpty((String)((String)config.getProperty(KEYTAB_IMPERSONATION_LOCATION)))) {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.SIMPLE.getValue());
            } else {
                config.setProperty(IMPERSONATION, (Object)IMPERSONATION_TYPE.DISABLED.getValue());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            log.logMinimal(e.getMessage());
        }
    }

    private void setupKnoxSecurity(NamedCluster nc, ThinNameClusterModel model) {
        if (model.getSecurityType() != null && model.getSecurityType().equals(SECURITY_TYPE.KNOX.getValue())) {
            String userName = model.getGatewayUsername();
            String url = model.getGatewayUrl();
            String password = model.getGatewayPassword();
            nc.setGatewayPassword(nc.encodePassword(password));
            nc.setGatewayUrl(url);
            nc.setGatewayUsername(userName);
            nc.setUseGateway(!StringUtil.isEmpty((String)userName) && !StringUtil.isEmpty((String)url) && !StringUtil.isEmpty((String)password));
        }
    }

    private Map<String, String> extractHostAndPort(String urlPattern) {
        String HTTP_PATTERN = "http://";
        if (!urlPattern.startsWith("http://")) {
            urlPattern = "http://" + urlPattern;
        }
        URI parsedURI = URI.create(urlPattern);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", parsedURI.getHost());
        map.put("port", parsedURI.getPort() != -1 ? parsedURI.getPort() + "" : "");
        return map;
    }

    public void deleteNamedCluster(IMetaStore metaStore, String namedCluster, boolean refreshTree) {
        try {
            if (this.namedClusterService.read(namedCluster, metaStore) != null) {
                this.namedClusterService.delete(namedCluster, metaStore);
                this.deleteConfigFolder(namedCluster);
            }
            if (refreshTree) {
                this.refreshTree();
            }
        }
        catch (Exception e) {
            log.logMinimal(e.getMessage());
        }
    }

    List<ShimIdentifierInterface> getShimIdentifiers() {
        List<ShimIdentifierInterface> shims = this.shimIdentifiersSupplier.get();
        shims.sort(Comparator.comparing(ShimIdentifierInterface::getVendor));
        return shims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runTests(RuntimeTester runtimeTester, String namedCluster) {
        NamedCluster nc = this.namedClusterService.getNamedClusterByName(namedCluster, this.metaStore);
        if (nc != null) {
            block7: {
                try {
                    if (runtimeTester == null) break block7;
                    this.runtimeTestStatus = null;
                    runtimeTester.runtimeTest((Object)nc, (RuntimeTestProgressCallback)this);
                    HadoopClusterManager hadoopClusterManager = this;
                    synchronized (hadoopClusterManager) {
                        while (this.runtimeTestStatus == null) {
                            this.wait();
                        }
                    }
                }
                catch (Exception e) {
                    log.logMinimal(e.getLocalizedMessage());
                }
            }
            return this.produceTestCategories(this.runtimeTestStatus, nc);
        }
        return "[]";
    }

    private Object[] produceTestCategories(RuntimeTestStatus runtimeTestStatus, NamedCluster nc) {
        LinkedHashMap<String, TestCategory> categories = new LinkedHashMap<String, TestCategory>();
        categories.put("Hadoop File System", new TestCategory("Hadoop file system"));
        categories.put("Zookeeper", new TestCategory("Zookeeper connection"));
        categories.put("Map Reduce", new TestCategory("Job tracker / resource manager"));
        categories.put("Oozie", new TestCategory("Oozie host connection"));
        categories.put("Kafka", new TestCategory("Kafka connection"));
        if (runtimeTestStatus != null && nc != null) {
            for (RuntimeTestModuleResults moduleResults : runtimeTestStatus.getModuleResults()) {
                for (RuntimeTestResult testResult : moduleResults.getRuntimeTestResults()) {
                    RuntimeTest runtimeTest = testResult.getRuntimeTest();
                    String name = runtimeTest.getName();
                    String status = this.getTestStatus(testResult.getOverallStatusEntry());
                    String module = runtimeTest.getModule();
                    Category category = (Category)categories.get(module);
                    category.setCategoryActive(true);
                    if (module.equals("Hadoop File System")) {
                        Test test = new Test(name);
                        test.setTestStatus(status);
                        test.setTestActive(true);
                        category.addTest(test);
                        this.configureHadoopFileSystemTestCategory(category, !StringUtil.isEmpty((String)nc.getHdfsHost()), status);
                        continue;
                    }
                    if (module.equals("Oozie")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getOozieUrl()), status);
                        continue;
                    }
                    if (module.equals("Kafka")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getKafkaBootstrapServers()), status);
                        continue;
                    }
                    if (module.equals("Zookeeper")) {
                        this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getZooKeeperHost()), status);
                        continue;
                    }
                    if (!module.equals("Map Reduce")) continue;
                    this.configureTestCategories(category, !StringUtil.isEmpty((String)nc.getJobTrackerHost()), status);
                }
            }
        }
        return categories.values().toArray();
    }

    private void configureHadoopFileSystemTestCategory(Category category, boolean isActive, String status) {
        category.setCategoryActive(isActive);
        if (category.isCategoryActive()) {
            String currentStatus = category.getCategoryStatus();
            if (status.equals(FAIL) || status.equals(WARNING) && !currentStatus.equals(FAIL) || status.equals(PASS) && StringUtil.isEmpty((String)currentStatus)) {
                category.setCategoryStatus(status);
            }
        }
    }

    private void configureTestCategories(Category category, boolean isActive, String status) {
        category.setCategoryActive(isActive);
        if (category.isCategoryActive()) {
            category.setCategoryStatus(status);
        }
    }

    private String getTestStatus(RuntimeTestResultEntry summary) {
        String status = "";
        switch (summary.getSeverity()) {
            case INFO: {
                status = PASS;
                break;
            }
            case SKIPPED: {
                status = WARNING;
                break;
            }
            case FATAL: {
                status = FAIL;
                break;
            }
            case ERROR: {
                status = FAIL;
                break;
            }
            case WARNING: {
                status = FAIL;
                break;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(RuntimeTestStatus clusterTestStatus) {
        HadoopClusterManager hadoopClusterManager = this;
        synchronized (hadoopClusterManager) {
            if (clusterTestStatus.isDone()) {
                this.runtimeTestStatus = clusterTestStatus;
                this.notifyAll();
            }
        }
    }

    @VisibleForTesting
    void refreshTree() {
        if (this.spoon != null && this.spoon.getShell() != null) {
            this.spoon.getShell().getDisplay().asyncExec(() -> this.spoon.refreshTree(STRING_NAMED_CLUSTERS));
        }
    }

    @VisibleForTesting
    String getNamedClusterConfigsRootDir() {
        return System.getProperty("user.home") + File.separator + ".pentaho" + File.separator + "metastore" + File.separator + "pentaho" + File.separator + "NamedCluster" + File.separator + "Configs";
    }

    private static enum IMPERSONATION_TYPE {
        SIMPLE("simple"),
        DISABLED("disabled");

        private String val;

        private IMPERSONATION_TYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }

    private static enum SECURITY_TYPE {
        NONE("None"),
        KERBEROS("Kerberos"),
        KNOX("Knox");

        private String val;

        private SECURITY_TYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }

    private static enum KERBEROS_SUBTYPE {
        PASSWORD("Password"),
        KEYTAB("Keytab");

        private String val;

        private KERBEROS_SUBTYPE(String val) {
            this.val = val;
        }

        public String getValue() {
            return this.val;
        }
    }
}

