/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONObject;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.CachedFileItemStream;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.HadoopClusterManager;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.model.ThinNameClusterModel;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.pentaho.runtime.test.RuntimeTester;

public class HadoopClusterEndpoints {
    private static final LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)"HadoopClusterEndpoints");
    private final Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private final NamedClusterService namedClusterService;
    private final MetastoreLocator metastoreLocator;
    private final RuntimeTester runtimeTester;
    private final String internalShim;
    private final boolean secureEnabled;
    private static final String MOD_DATE_FILENAME_PREFIX = "mod-";
    private static final String FILE_CONTENT_FILENAME_PREFIX = "file-";
    private static final String ZERO = "0";

    public HadoopClusterEndpoints(MetastoreLocator metastoreLocator, NamedClusterService namedClusterService, RuntimeTester runtimeTester, String internalShim, boolean secureEnabled) {
        this.namedClusterService = namedClusterService;
        this.metastoreLocator = metastoreLocator;
        this.runtimeTester = runtimeTester;
        this.internalShim = internalShim;
        this.secureEnabled = secureEnabled;
    }

    private HadoopClusterManager getClusterManager() {
        return new HadoopClusterManager(this.spoonSupplier.get(), this.namedClusterService, this.metastoreLocator.getMetastore(), this.internalShim);
    }

    private Map<String, CachedFileItemStream> parseRequest(HttpServletRequest request, FileType fileType) {
        HashMap<String, CachedFileItemStream> fileStreamByName = new HashMap<String, CachedFileItemStream>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                CachedFileItemStream lastCachedFileInputStream = null;
                FileItemIterator streamItemIterator = new ServletFileUpload().getItemIterator(request);
                while (streamItemIterator.hasNext()) {
                    String realFileName;
                    FileItemStream fileItemStream = streamItemIterator.next();
                    if (fileItemStream.getFieldName().startsWith(MOD_DATE_FILENAME_PREFIX)) {
                        realFileName = this.removePrefix(fileItemStream.getFieldName(), MOD_DATE_FILENAME_PREFIX);
                        if (lastCachedFileInputStream == null || !realFileName.equals(lastCachedFileInputStream.getFieldName())) continue;
                        String millis = ZERO;
                        try (InputStream is = fileItemStream.openStream();){
                            millis = IOUtils.toString((InputStream)fileItemStream.openStream(), (String)String.valueOf(StandardCharsets.UTF_8));
                        }
                        long modificationDateMillis = Long.parseLong(millis);
                        lastCachedFileInputStream.setLastModified(modificationDateMillis);
                        continue;
                    }
                    realFileName = this.removePrefix(fileItemStream.getFieldName(), FILE_CONTENT_FILENAME_PREFIX);
                    List<CachedFileItemStream> fileItemStreams = this.copyAndUnzip(fileItemStream, fileType, realFileName);
                    for (CachedFileItemStream cachedFileItemStream : fileItemStreams) {
                        fileStreamByName.put(cachedFileItemStream.getFieldName(), cachedFileItemStream);
                        lastCachedFileInputStream = cachedFileItemStream;
                    }
                }
            }
            catch (IOException | FileUploadException e) {
                log.logError(e.getMessage());
            }
        }
        return fileStreamByName;
    }

    private String removePrefix(String fieldName, String prefix) {
        return fieldName.startsWith(prefix) ? fieldName.substring(prefix.length()) : fieldName;
    }

    private boolean isValidUpload(String fileName, FileType fileType) {
        boolean valid = false;
        if (fileType.equals((Object)FileType.CONFIGURATION) && this.getClusterManager().isValidConfigurationFile(fileName) || fileType.equals((Object)FileType.DRIVER) && fileName.endsWith(FileType.DRIVER.getValue())) {
            valid = true;
        }
        return valid;
    }

    @VisibleForTesting
    List<CachedFileItemStream> copyAndUnzip(FileItemStream fileItemStream, FileType fileType, String realFileName) throws IOException {
        ArrayList<CachedFileItemStream> unzippedFileItemStreams = new ArrayList<CachedFileItemStream>();
        if (realFileName.endsWith(".zip")) {
            try (ZipInputStream zis = new ZipInputStream(fileItemStream.openStream());){
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    String[] split;
                    String unzippedFileName;
                    if (!zipEntry.isDirectory() && this.isValidUpload(unzippedFileName = (split = zipEntry.getName().split("/"))[split.length - 1], fileType)) {
                        CachedFileItemStream unzippedFileItemStream = new CachedFileItemStream(zis, fileItemStream.getName(), unzippedFileName);
                        unzippedFileItemStream.setLastModified(zipEntry.getLastModifiedTime().toMillis());
                        unzippedFileItemStreams.add(unzippedFileItemStream);
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
        } else if (this.isValidUpload(realFileName, fileType)) {
            unzippedFileItemStreams.add(new CachedFileItemStream(fileItemStream.openStream(), fileItemStream.getName(), realFileName));
        }
        return unzippedFileItemStreams;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/importNamedCluster")
    @Produces(value={"application/json"})
    public Response importNamedCluster(@Context HttpServletRequest request) {
        Map<String, CachedFileItemStream> siteFilesSource = this.parseRequest(request, FileType.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().importNamedCluster(model, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/createNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response createNamedCluster(@Context HttpServletRequest request) {
        Map<String, CachedFileItemStream> siteFilesSource = this.parseRequest(request, FileType.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().createNamedCluster(model, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/editNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response editNamedCluster(@Context HttpServletRequest request) {
        Map<String, CachedFileItemStream> siteFilesSource = this.parseRequest(request, FileType.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().editNamedCluster(model, true, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/duplicateNamedCluster")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response duplicateNamedCluster(@Context HttpServletRequest request) {
        Map<String, CachedFileItemStream> siteFilesSource = this.parseRequest(request, FileType.CONFIGURATION);
        ThinNameClusterModel model = ThinNameClusterModel.unmarshall(siteFilesSource);
        JSONObject response = this.getClusterManager().editNamedCluster(model, false, siteFilesSource);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/getNamedCluster")
    @Produces(value={"application/json"})
    public Response getNamedCluster(@QueryParam(value="namedCluster") String namedCluster) {
        return Response.ok((Object)this.getClusterManager().getNamedCluster(namedCluster)).build();
    }

    @GET
    @Path(value="/getShimIdentifiers")
    @Produces(value={"application/json"})
    public Response getShimIdentifiers() {
        return Response.ok(this.getClusterManager().getShimIdentifiers()).build();
    }

    @GET
    @Path(value="/runTests")
    @Produces(value={"application/json"})
    public Response runTests(@QueryParam(value="namedCluster") String namedCluster) {
        return Response.ok((Object)this.getClusterManager().runTests(this.runtimeTester, namedCluster)).build();
    }

    @POST
    @Path(value="/installDriver")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response installDriver(@Context HttpServletRequest request) {
        FileItemStream driver = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                FileItemStream fileItemStream;
                FileItemIterator streamItemIterator = new ServletFileUpload().getItemIterator(request);
                if (streamItemIterator.hasNext() && this.isValidUpload((fileItemStream = streamItemIterator.next()).getFieldName(), FileType.DRIVER)) {
                    driver = fileItemStream;
                }
            }
            catch (IOException | FileUploadException e) {
                log.logError(e.getMessage());
            }
        }
        return Response.ok((Object)this.getClusterManager().installDriver(driver)).build();
    }

    @GET
    @Path(value="/getSecure")
    @Produces(value={"application/json"})
    public Response getSecure() {
        return Response.ok((Object)("{\"secureEnabled\":\"" + Boolean.toString(this.secureEnabled) + "\"}")).build();
    }

    static enum FileType {
        CONFIGURATION("configuration"),
        DRIVER(".kar");

        private String val;

        private FileType(String val) {
            this.val = val;
        }

        String getValue() {
            return this.val;
        }
    }
}

