/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.io.IOUtils;

public class CachedFileItemStream {
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private String name;
    private String fieldName;
    private long lastModified;

    public CachedFileItemStream(FileItemStream fileItemStream) throws IOException {
        this(fileItemStream.openStream(), fileItemStream.getName(), fileItemStream.getFieldName());
    }

    public CachedFileItemStream(InputStream inputStream, String name, String fieldName) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
        this.name = name;
        this.fieldName = fieldName;
    }

    public ByteArrayOutputStream getCachedOutputStream() {
        return this.outputStream;
    }

    public ByteArrayInputStream getCachedInputStream() {
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }
}

