/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.kettle.plugins.hadoopcluster.ui.endpoints.HadoopClusterManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class HadoopClusterDialog
extends ThinDialog {
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final int OPTIONS = 3184;
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "127.0.0.1";
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private final LogChannelInterface log = this.spoonSupplier.get().getLog();

    HadoopClusterDialog(Shell shell, int width, int height) {
        super(shell, width, height, true);
    }

    void open(String title, String thinAppState, Map<String, String> urlParams) {
        StringBuilder clientPath = new StringBuilder();
        clientPath.append(this.getClientPath());
        clientPath.append("#!/");
        if (thinAppState != null) {
            clientPath.append(thinAppState);
        }
        HashMap<String, String> params = new HashMap<String, String>(urlParams);
        params.put("connectedToRepo", Boolean.toString(this.connectedToRepo()));
        String paramString = params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).map(s -> "?" + s).orElse("");
        clientPath.append(paramString);
        String endpointURL = this.getEndpointURL(clientPath.toString());
        this.log.logDebug("Thin endpoint URL:  " + endpointURL);
        super.createDialog(title, endpointURL, 3184, LOGO);
        this.dialog.setMinimumSize(640, 630);
        new BrowserFunction(this.browser, "open"){

            public Object function(Object[] arguments) {
                HelpUtils.openHelpDialog((Shell)((Spoon)HadoopClusterDialog.this.spoonSupplier.get()).getDisplay().getActiveShell(), (String)"", (String)((String)arguments[0]), (String)"");
                return true;
            }
        };
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                Runnable execute = () -> {
                    HadoopClusterDialog.this.browser.dispose();
                    HadoopClusterDialog.this.dialog.close();
                    HadoopClusterDialog.this.dialog.dispose();
                };
                HadoopClusterDialog.this.display.asyncExec(execute);
                return true;
            }
        };
        new BrowserFunction(this.browser, "setTitle"){

            public Object function(Object[] arguments) {
                Runnable execute = () -> HadoopClusterDialog.this.dialog.setText((String)arguments[0]);
                HadoopClusterDialog.this.display.asyncExec(execute);
                return true;
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        Spoon spoon = this.spoonSupplier.get();
        if (spoon != null && spoon.getShell() != null) {
            spoon.getShell().getDisplay().asyncExec(() -> spoon.refreshTree(HadoopClusterManager.STRING_NAMED_CLUSTERS));
        }
    }

    private String getClientPath() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = HadoopClusterDialog.class.getClassLoader().getResourceAsStream("project.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            this.log.logError(e.getMessage(), (Throwable)e);
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private int getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        throw new IllegalStateException("No osgi service port defined");
    }

    private String getEndpointURL(String path) {
        int port;
        String host;
        if (this.connectedToRepo()) {
            return ((URI)this.getRepo().getUri().orElseThrow(() -> new IllegalStateException("Repo URI not defined"))).toString() + "/osgi" + path;
        }
        if (Const.isRunningOnWebspoonMode()) {
            return System.getProperty("KETTLE_CONTEXT_PATH", "") + "/osgi" + path;
        }
        try {
            host = this.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.parseInt(this.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = this.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private boolean connectedToRepo() {
        Repository repo = this.getRepo();
        return repo != null && repo.getUri().isPresent();
    }

    private Repository getRepo() {
        return this.spoonSupplier.get().getRepository();
    }

    private String getKettleProperty(String propertyName) {
        return System.getProperty(propertyName);
    }
}

