/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import org.pentaho.big.data.kettle.plugins.hive.Hive2DatabaseMeta;
import org.pentaho.big.data.kettle.plugins.hive.SimbaUrl;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.jdbc.DriverLocator;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

abstract class BaseSimbaDatabaseMeta
extends Hive2DatabaseMeta {
    @VisibleForTesting
    static final String ODBC_DRIVER_CLASS_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    @VisibleForTesting
    static final String URL_IS_CONFIGURED_THROUGH_JNDI = "Url is configured through JNDI";
    @VisibleForTesting
    static final String JDBC_ODBC_S = "jdbc:odbc:%s";

    BaseSimbaDatabaseMeta(DriverLocator driverLocator, NamedClusterService namedClusterService, MetastoreLocator metastoreLocator) {
        super(driverLocator, namedClusterService, metastoreLocator);
    }

    protected abstract String getJdbcPrefix();

    @Override
    public abstract String getDriverClass();

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        return SimbaUrl.Builder.create().withAccessType(this.getAccessType()).withDatabaseName(databaseName).withPort(port).withDefaultPort(this.getDefaultDatabasePort()).withHostname(hostname).withJdbcPrefix(this.getJdbcPrefix()).withUsername(this.getUsername()).withPassword(this.getPassword()).withIsKerberos(this.isKerberos()).build().getURL();
    }

    private String getExtraProperty(String key) {
        return this.getAttributes().getProperty("EXTRA_OPTION_" + this.getPluginId() + "." + key);
    }

    private String getProperty(String key) {
        return this.getAttributes().getProperty(key);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        StringBuilder retval = new StringBuilder();
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval.append("BOOLEAN");
                break;
            }
            case 3: {
                retval.append("DATE");
                break;
            }
            case 9: {
                retval.append("TIMESTAMP");
                break;
            }
            case 2: {
                retval.append("VARCHAR");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval.append("BIGINT");
                            break;
                        }
                        retval.append("FLOAT");
                        break;
                    }
                    retval.append("INT");
                    break;
                }
                if (length > 15) {
                    retval.append("FLOAT");
                    break;
                }
                retval.append("DOUBLE");
            }
        }
        return retval.toString();
    }

    private boolean isKerberos() {
        return !Strings.isNullOrEmpty((String)this.getProperty("KrbHostFQDN")) || !Strings.isNullOrEmpty((String)this.getExtraProperty("KrbHostFQDN")) || !Strings.isNullOrEmpty((String)this.getProperty("KrbServiceName")) || !Strings.isNullOrEmpty((String)this.getExtraProperty("KrbServiceName"));
    }
}

