/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceAlreadyExistsException;
import org.pentaho.di.trans.dataservice.serialization.DataServiceReferenceSynchronizer;
import org.pentaho.di.trans.dataservice.serialization.TransOpenedExtensionPointPlugin;
import org.pentaho.di.trans.dataservice.serialization.UndefinedDataServiceException;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class SynchronizationListener
implements ContentChangedListener,
StepMetaChangeListenerInterface {
    private static Class<TransOpenedExtensionPointPlugin> PKG = TransOpenedExtensionPointPlugin.class;
    private final DataServiceDelegate delegate;
    private final DataServiceReferenceSynchronizer synchronizer;
    private boolean prompt = true;

    public SynchronizationListener(DataServiceDelegate delegate, DataServiceReferenceSynchronizer synchronizer) {
        this.delegate = delegate;
        this.synchronizer = synchronizer;
    }

    public void contentChanged(Object parentObject) {
    }

    public void contentSafe(Object parentObject) {
        this.synchronizer.sync((TransMeta)parentObject, e -> {
            String message = e.getMessage();
            if (this.prompt) {
                DataServiceMeta dataService;
                if (e instanceof DataServiceAlreadyExistsException) {
                    dataService = ((DataServiceAlreadyExistsException)((Object)((Object)e))).getDataServiceMeta();
                    this.delegate.syncExec(this.suggestEdit(dataService, message));
                }
                if (e instanceof UndefinedDataServiceException) {
                    dataService = ((UndefinedDataServiceException)((Object)((Object)e))).getDataServiceMeta();
                    this.delegate.syncExec(this.suggestRemove(dataService, message));
                }
            }
            this.delegate.getLogChannel().logError(message, (Throwable)e);
            return null;
        });
    }

    public void onStepChange(TransMeta transMeta, StepMeta oldMeta, StepMeta newMeta) {
        if (Objects.equal((Object)oldMeta.getName(), (Object)newMeta.getName())) {
            return;
        }
        try {
            DataServiceMeta dataService = this.delegate.getDataServiceByStepName(transMeta, oldMeta.getName());
            if (dataService != null) {
                dataService.setStepname(newMeta.getName());
                this.delegate.save(dataService);
            }
        }
        catch (MetaStoreException e) {
            this.delegate.getLogChannel().logError(e.getMessage(), (Throwable)e);
        }
    }

    private Runnable suggestEdit(final DataServiceMeta dataService, final String message) {
        return new Runnable(){

            @Override
            public void run() {
                SynchronizationListener.this.delegate.suggestEdit(dataService, BaseMessages.getString((Class)PKG, (String)"Messages.SaveError.Title", (String[])new String[0]), message + "\n" + BaseMessages.getString((Class)PKG, (String)"Messages.SaveError.Edit", (String[])new String[0]));
            }
        };
    }

    private Runnable suggestRemove(final DataServiceMeta dataService, final String message) {
        return new Runnable(){

            @Override
            public void run() {
                boolean remove = SynchronizationListener.this.delegate.showPrompt(BaseMessages.getString((Class)PKG, (String)"Messages.SaveError.Title", (String[])new String[0]), message + "\n" + BaseMessages.getString((Class)PKG, (String)"Messages.SaveError.Remove", (String[])new String[0]));
                if (remove) {
                    SynchronizationListener.this.delegate.removeDataService(dataService);
                }
            }
        };
    }

    public void install(TransMeta transMeta) {
        List listeners = transMeta.getContentChangedListeners();
        if (FluentIterable.from((Iterable)listeners).filter(SynchronizationListener.class).isEmpty()) {
            transMeta.addContentChangedListener((ContentChangedListener)this);
            transMeta.addStepChangeListener((StepMetaChangeListenerInterface)this);
        }
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }
}

