/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.pushdown;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.pushdown.ParameterPushdown;
import org.pentaho.di.trans.dataservice.optimization.pushdown.ui.ParameterPushdownController;
import org.pentaho.di.trans.dataservice.optimization.pushdown.ui.ParameterPushdownModel;
import org.pentaho.di.trans.dataservice.ui.DataServiceDialog;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class ParameterPushdownFactory
implements PushDownFactory {
    @VisibleForTesting
    static final String XUL_SOURCE = "/org/pentaho/di/trans/dataservice/optimization/pushdown/ui/overlay.xul";

    @Override
    public String getName() {
        return "Parameter Capture";
    }

    public Class<ParameterPushdown> getType() {
        return ParameterPushdown.class;
    }

    @Override
    public ParameterPushdown createPushDown() {
        return new ParameterPushdown();
    }

    @Override
    public DataServiceDialog.OptimizationOverlay createOverlay() {
        return new DataServiceDialog.OptimizationOverlay(){

            @Override
            public double getPriority() {
                return 2.0;
            }

            @Override
            public void apply(DataServiceDialog dialog) throws KettleException {
                ParameterPushdownController controller = ParameterPushdownFactory.this.createController(dialog.getModel());
                dialog.applyOverlay(this, ParameterPushdownFactory.XUL_SOURCE).addEventHandler((XulEventHandler)controller);
            }
        };
    }

    protected ParameterPushdownController createController(DataServiceModel dialogModel) {
        return new ParameterPushdownController(this.createModel(dialogModel));
    }

    public ParameterPushdownModel createModel(final DataServiceModel dialogModel) {
        ParameterPushdown parameterPushdown;
        ImmutableList<PushDownOptimizationMeta> optimizations = dialogModel.getPushDownOptimizations(ParameterPushdown.class);
        if (optimizations.isEmpty()) {
            parameterPushdown = this.createPushDown();
            PushDownOptimizationMeta optimizationMeta = new PushDownOptimizationMeta();
            optimizationMeta.setStepName(dialogModel.getServiceStep());
            optimizationMeta.setType(parameterPushdown);
            dialogModel.add(optimizationMeta);
        } else {
            parameterPushdown = (ParameterPushdown)((PushDownOptimizationMeta)optimizations.get(0)).getType();
        }
        if (optimizations.size() > 1) {
            dialogModel.removeAll(optimizations.subList(1, optimizations.size()));
        }
        final ParameterPushdownModel parameterPushdownModel = new ParameterPushdownModel(parameterPushdown);
        parameterPushdownModel.setFieldList(dialogModel.getStepFields());
        dialogModel.addPropertyChangeListener("serviceStep", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                parameterPushdownModel.setFieldList(dialogModel.getStepFields());
            }
        });
        return parameterPushdownModel;
    }
}

