/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen.ui;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.paramgen.AutoParameterGenerationService;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.ParameterGenerationModel;
import org.pentaho.di.trans.dataservice.ui.BindingConverters;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class ParameterGenerationController
extends AbstractController {
    private static final Class<?> PKG = ParameterGenerationController.class;
    private static final String NAME = "paramGenCtrl";
    private final ParameterGenerationFactory factory;
    private final ParameterGenerationModel model;

    public ParameterGenerationController(ParameterGenerationFactory factory, ParameterGenerationModel model) {
        this.setName(NAME);
        this.factory = factory;
        this.model = model;
    }

    public void initBindings(List<String> supportedSteps) {
        BindingFactory bindingFactory = this.getBindingFactory();
        XulMenuList<String> stepList = this.getStepMenuList();
        stepList.setElements(supportedSteps);
        this.getElementById("param_gen_add").setDisabled(supportedSteps.isEmpty());
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "selectedParameter", "param_gen_list", "selectedItem", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)this.model, "selectedStep", stepList, "value", new BindingConvertor[0]);
        bindingFactory.createBinding((Object)this.model, "enabled", "param_gen_enabled", "checked", new BindingConvertor[]{BindingConverters.not()});
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindingFactory.createBinding((Object)this.model, "parameterMap", "param_gen_list", "elements", new BindingConvertor[]{BindingConverters.keySet()});
        bindingFactory.createBinding((Object)this.model, "selectedParameter", "param_gen_edit", "disabled", new BindingConvertor[]{BindingConverters.stringIsEmpty()});
        bindingFactory.createBinding((Object)this.model, "selectedParameter", "param_gen_remove", "disabled", new BindingConvertor[]{BindingConverters.stringIsEmpty()});
        bindingFactory.createBinding((Object)this.model, "selectedParameter", "param_gen_enabled", "disabled", new BindingConvertor[]{BindingConverters.stringIsEmpty()});
        bindingFactory.createBinding((Object)this.model, "enabled", "param_gen_step", "disabled", new BindingConvertor[]{BindingConverters.not()});
        bindingFactory.createBinding((Object)this.model, "enabled", "param_gen_mapping", "disabled", new BindingConvertor[]{BindingConverters.not()});
        bindingFactory.createBinding((Object)this.model, "mappings", "param_gen_mapping", "elements", new BindingConvertor[0]);
        this.model.updateParameterMap();
    }

    private XulMenuList<String> getStepMenuList() {
        return (XulMenuList)this.getElementById("param_gen_step");
    }

    public void runAutoGenerate() throws XulException {
        DataServiceModel dialogModel = this.model.getDialogModel();
        try {
            AutoParameterGenerationService autoOptimizationService = this.factory.createAutoOptimizationService();
            Collection<PushDownOptimizationMeta> found = autoOptimizationService.apply(dialogModel.getDataService());
            if (dialogModel.addAll(found)) {
                this.model.updateParameterMap();
            }
            this.info(BaseMessages.getString(PKG, (String)"ParameterGenerationController.AutoGen.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ParameterGenerationController.AutoGen.Message", (Object[])new Object[]{found.size()}));
        }
        catch (Exception e) {
            String message = BaseMessages.getString(PKG, (String)"ParameterGenerationController.AutoGen.Error", (String[])new String[0]);
            this.getLogChannel().logError(message, (Throwable)e);
            this.error(BaseMessages.getString(PKG, (String)"ParameterGenerationController.AutoGen.Title", (String[])new String[0]), message);
        }
    }

    public void addParameter() throws XulException {
        PushDownOptimizationMeta meta = new PushDownOptimizationMeta();
        ParameterGeneration parameterGeneration = this.factory.createPushDown();
        meta.setType(parameterGeneration);
        meta.setStepName(this.getStepMenuList().getSelectedItem());
        XulPromptBox promptBox = this.createPromptBox();
        promptBox.setTitle(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Create.Title", (String[])new String[0]));
        promptBox.setMessage(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Create.Message", (String[])new String[0]));
        ParameterEditor editor = new ParameterEditor(parameterGeneration);
        promptBox.addDialogCallback((XulDialogCallback)editor);
        if (promptBox.open() == 0 && editor.modified) {
            this.model.add(meta);
            this.model.setSelectedParameter(parameterGeneration.getParameterName());
        }
    }

    public void editParameter() throws XulException {
        ParameterGeneration parameterGeneration = (ParameterGeneration)Preconditions.checkNotNull((Object)this.model.getParameterGeneration());
        XulPromptBox promptBox = this.createPromptBox();
        promptBox.setTitle(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Edit.Title", (String[])new String[0]));
        promptBox.setMessage(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Edit.Message", (String[])new String[0]));
        promptBox.setValue(parameterGeneration.getParameterName());
        ParameterEditor editor = new ParameterEditor(parameterGeneration);
        promptBox.addDialogCallback((XulDialogCallback)editor);
        if (promptBox.open() == 0 && editor.modified) {
            this.model.updateParameterMap();
            this.model.setSelectedParameter(parameterGeneration.getParameterName());
        }
    }

    public void removeParameter() throws XulException {
        PushDownOptimizationMeta meta = (PushDownOptimizationMeta)Preconditions.checkNotNull((Object)this.model.getSelectedOptimization());
        String parameterName = ((ParameterGeneration)meta.getType()).getParameterName();
        XulMessageBox messageBox = this.createMessageBox();
        messageBox.setTitle(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Delete.Title", (String[])new String[0]));
        messageBox.setMessage(BaseMessages.getString(PKG, (String)"ParameterGenerationController.Delete.Message", (String[])new String[]{parameterName}));
        messageBox.setIcon((Object)4);
        messageBox.setButtons(new Object[]{64, 128});
        if (messageBox.open() == 64) {
            this.model.setSelectedParameter(null);
            this.model.remove(meta);
        }
    }

    private class ParameterEditor
    implements XulDialogCallback<String> {
        private final ParameterGeneration parameterGeneration;
        private boolean modified;

        public ParameterEditor(ParameterGeneration parameterGeneration) {
            this.parameterGeneration = parameterGeneration;
            this.modified = false;
        }

        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, String retVal) {
            try {
                if (returnCode == XulDialogCallback.Status.ACCEPT && this.validate(retVal)) {
                    this.parameterGeneration.setParameterName(retVal);
                    this.modified = true;
                }
            }
            catch (XulException e) {
                this.onError(sender, e);
            }
        }

        private boolean validate(String parameterName) throws XulException {
            if (Strings.isNullOrEmpty((String)parameterName)) {
                ParameterGenerationController.this.error(BaseMessages.getString((Class)PKG, (String)"ParameterGenerationController.NameMissing.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ParameterGenerationController.NameMissing.Message", (String[])new String[0]));
                return false;
            }
            if (parameterName.equals(this.parameterGeneration.getParameterName())) {
                return false;
            }
            if (ParameterGenerationController.this.model.getParameterMap().containsKey((Object)parameterName)) {
                ParameterGenerationController.this.error(BaseMessages.getString((Class)PKG, (String)"ParameterGenerationController.NameExist.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ParameterGenerationController.NameExist.Message", (String[])new String[0]));
                return false;
            }
            return true;
        }

        public void onError(XulComponent sender, Throwable t) {
            ParameterGenerationController.this.getLogChannel().logError("Failed to modify Parameter Generation", t);
        }
    }
}

