/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.cache.Cache;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.pentaho.caching.api.PentahoCacheTemplateConfiguration;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.di.trans.dataservice.optimization.StepOptimization;
import org.pentaho.di.trans.dataservice.optimization.cache.CachedService;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceObserver;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.metastore.persist.MetaStoreAttribute;

public class ServiceCache
extends StepOptimization {
    public static final String NAME = "Service Cache";
    private final ServiceCacheFactory factory;
    public static final String SERVICE_CACHE_TEMPLATE_NAME = "template_name";
    public static final String SERVICE_CACHE_TTL = "time_to_live";
    @MetaStoreAttribute(key="template_name")
    private String templateName = "default";
    @MetaStoreAttribute(key="time_to_live")
    private String timeToLive;

    public ServiceCache(ServiceCacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public void init(TransMeta transMeta, DataServiceMeta dataService, PushDownOptimizationMeta optMeta) {
        optMeta.setStepName(dataService.getStepname());
    }

    @Override
    public boolean activate(final DataServiceExecutor executor, StepInterface stepInterface) {
        if (!executor.getService().isStreaming()) {
            final LogChannelInterface logChannel = executor.getGenTrans().getLogChannel();
            for (CachedService availableCache : this.getAvailableCache(executor).values()) {
                try {
                    ListenableFuture<Integer> replay = this.factory.createCachedServiceLoader(availableCache).replay(executor);
                    this.addReplayCallback(logChannel, replay);
                    return true;
                }
                catch (Throwable e) {
                    logChannel.logError("Unable to replay from cache", e);
                }
            }
            final CachedService.CacheKey rootKey = this.createRootKey(executor);
            final Map<CachedService.CacheKey, ServiceObserver> runningServices = this.factory.getRunningServices();
            if (runningServices.containsKey(rootKey)) {
                try {
                    ListenableFuture<Integer> replay = this.factory.createCachedServiceLoader(() -> ((ServiceObserver)runningServices.get(rootKey)).rows()).replay(executor);
                    this.addReplayCallback(logChannel, replay);
                    return true;
                }
                catch (KettleException e) {
                    logChannel.logError("Unable to replay from running service");
                }
            }
            ServiceObserver serviceObserver = this.factory.createObserver(executor);
            if (CachedService.calculateRank(executor) == Integer.MAX_VALUE) {
                runningServices.put(rootKey, serviceObserver);
            }
            Futures.addCallback(serviceObserver.install(), (FutureCallback)new FutureCallback<CachedService>(){

                public void onSuccess(CachedService result) {
                    if (executor.isStopped() || executor.hasErrors().booleanValue()) {
                        runningServices.remove(rootKey);
                        return;
                    }
                    Cache<CachedService.CacheKey, CachedService> cache = ServiceCache.this.factory.getCache(ServiceCache.this, executor.getServiceName());
                    CachedService.CacheKey key = ServiceCache.this.createRootKey(executor);
                    if (result.isComplete()) {
                        key = key.withoutOrder();
                    }
                    if (cache.putIfAbsent((Object)key, (Object)result)) {
                        logChannel.logBasic("Service Transformation results cached", new Object[]{key});
                    } else {
                        try {
                            CachedService existing = (CachedService)Preconditions.checkNotNull((Object)((CachedService)cache.get((Object)key)));
                            if (!existing.answersQuery(executor) && cache.replace((Object)key, (Object)existing, (Object)result)) {
                                logChannel.logBasic("Service Transformation cache updated", new Object[]{key});
                            } else {
                                logChannel.logDetailed("Service Transformation cache was not updated", new Object[]{key});
                            }
                        }
                        catch (Throwable t) {
                            this.onFailure(t);
                        }
                    }
                    runningServices.remove(rootKey);
                }

                public void onFailure(Throwable t) {
                    runningServices.remove(rootKey);
                    logChannel.logError("Cache failed to observe service transformation", t);
                }
            }, (Executor)this.factory.getExecutorService());
        }
        return false;
    }

    private void addReplayCallback(final LogChannelInterface logChannel, ListenableFuture<Integer> replay) {
        Futures.addCallback(replay, (FutureCallback)new FutureCallback<Integer>(){

            public void onSuccess(Integer rowCount) {
                logChannel.logBasic("Service Transformation successfully replayed " + rowCount + " rows from cache");
            }

            public void onFailure(Throwable t) {
                logChannel.logError("Cache failed to replay service transformation", t);
            }
        }, (Executor)this.factory.getExecutorService());
    }

    @Override
    public OptimizationImpactInfo preview(DataServiceExecutor executor, StepInterface stepInterface) {
        OptimizationImpactInfo info = new OptimizationImpactInfo(executor.getService().getStepname());
        Map<CachedService.CacheKey, CachedService> availableCache = this.getAvailableCache(executor);
        Iterator<Map.Entry<CachedService.CacheKey, CachedService>> iterator = availableCache.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<CachedService.CacheKey, CachedService> available = iterator.next();
            info.setModified(true);
            info.setQueryBeforeOptimization(MessageFormat.format("Service results for {0} are available.", available.getKey()));
            info.setQueryAfterOptimization(MessageFormat.format("{0} rows can be read from cache.", available.getValue().getRowMetaAndData().size()));
            return info;
        }
        info.setModified(false);
        info.setQueryBeforeOptimization("Service results are not available. Execute this query to cache results.");
        return info;
    }

    public CachedService.CacheKey createRootKey(DataServiceExecutor executor) {
        CachedService.CacheKey rootKey = CachedService.CacheKey.create(executor);
        if (!this.isPushDownOptimized(executor)) {
            rootKey = rootKey.withoutCondition();
        }
        return rootKey;
    }

    Map<CachedService.CacheKey, CachedService> getAvailableCache(DataServiceExecutor executor) {
        final Cache<CachedService.CacheKey, CachedService> cache = this.maybeInvalidateCache(executor);
        if (cache == null) {
            return ImmutableMap.of();
        }
        CachedService.CacheKey rootKey = this.createRootKey(executor);
        CachedService exactMatch = (CachedService)cache.get((Object)rootKey);
        if (exactMatch != null && exactMatch.answersQuery(executor)) {
            return ImmutableMap.of((Object)rootKey, (Object)exactMatch);
        }
        return (Map)FluentIterable.from(rootKey.all()).transform((Function)new Function<CachedService.CacheKey, Map<CachedService.CacheKey, CachedService>>(){

            public Map<CachedService.CacheKey, CachedService> apply(CachedService.CacheKey key) {
                CachedService value = (CachedService)cache.get((Object)key);
                return value != null && value.isComplete() ? ImmutableMap.of((Object)key, (Object)value) : null;
            }
        }).filter(Predicates.notNull()).first().or((Object)ImmutableMap.of());
    }

    private Cache<CachedService.CacheKey, CachedService> maybeInvalidateCache(DataServiceExecutor executor) {
        Optional<Cache<CachedService.CacheKey, CachedService>> cache = this.factory.getCache(executor.getServiceName());
        LogChannelInterface logChannel = executor.getServiceTrans().getLogChannel();
        if (cache.isPresent()) {
            if (!this.ttlMatches((Cache<CachedService.CacheKey, CachedService>)((Cache)cache.get()), logChannel)) {
                logChannel.logBasic("Dropping cache associated with " + executor.getServiceName());
                this.dropCache((Cache<CachedService.CacheKey, CachedService>)((Cache)cache.get()));
            } else {
                logChannel.logDebug("Found cache associated with " + executor.getServiceName());
                return (Cache)cache.get();
            }
        }
        return null;
    }

    private boolean ttlMatches(Cache<CachedService.CacheKey, CachedService> cache, LogChannelInterface log) {
        CompleteConfiguration config = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
        if (this.getTimeToLive() == null) {
            return true;
        }
        if (config != null) {
            try {
                Duration duration = this.getConfigDuration(config);
                long ttl = Long.parseLong(this.getTimeToLive());
                return ttl == duration.getDurationAmount();
            }
            catch (NumberFormatException nfe) {
                log.logError(String.format("Failed to determine configured TTL value for cache '%s'.  TTL value = '%s'", cache.getName(), this.getTimeToLive()));
                throw nfe;
            }
        }
        log.logError(String.format("Failed to check TTL consistency with cache for name '%s'.\n  Assuming cache can be used", cache.getName()));
        return true;
    }

    private synchronized void dropCache(Cache<CachedService.CacheKey, CachedService> cache) {
        if (!cache.isClosed()) {
            cache.clear();
            cache.close();
        }
    }

    private Duration getConfigDuration(CompleteConfiguration config) {
        ExpiryPolicy policy = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
        return policy.getExpiryForAccess();
    }

    boolean isPushDownOptimized(DataServiceExecutor executor) {
        return FluentIterable.from(executor.getService().getPushDownOptimizationMeta()).transform((Function)new Function<PushDownOptimizationMeta, PushDownType>(){

            public PushDownType apply(PushDownOptimizationMeta input) {
                return input.getType();
            }
        }).anyMatch(Predicates.not((Predicate)Predicates.instanceOf(ServiceCache.class)));
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(String timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getConfiguredTimeToLive() {
        PentahoCacheTemplateConfiguration configuration = this.factory.getPentahoCacheTemplateConfiguration(this);
        return (String)configuration.getProperties().get("ttl");
    }

    public Map<String, String> getTemplateOverrides() {
        if (this.getTimeToLive() != null) {
            return ImmutableMap.of((Object)"ttl", (Object)this.getTimeToLive());
        }
        return Collections.emptyMap();
    }
}

