/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class TransMutators {
    public static void disableAllUnrelatedHops(String stepName, TransMeta serviceTrans, boolean includeTargetedSteps) {
        StepMeta step = serviceTrans.findStep(stepName);
        List<TransHopMeta> allHops = IntStream.range(0, serviceTrans.nrTransHops()).mapToObj(arg_0 -> ((TransMeta)serviceTrans).getTransHop(arg_0)).collect(Collectors.toList());
        HashSet<TransHopMeta> upstreamHops = new HashSet<TransHopMeta>();
        TransMutators.findUpstreamHops(upstreamHops, allHops, step, includeTargetedSteps);
        if (upstreamHops.isEmpty()) {
            serviceTrans.getSteps().clear();
            serviceTrans.addStep(step);
            IntStream.generate(() -> 0).limit(serviceTrans.nrTransHops()).forEach(arg_0 -> ((TransMeta)serviceTrans).removeTransHop(arg_0));
        } else {
            allHops.stream().filter(thm -> !upstreamHops.contains(thm)).forEach(thm -> thm.setEnabled(false));
        }
    }

    private static void findUpstreamHops(Set<TransHopMeta> upstreamHops, List<TransHopMeta> all, StepMeta step, boolean includeTargetedSteps) {
        for (TransHopMeta hop : all) {
            if (!hop.getToStep().equals((Object)step) || upstreamHops.contains(hop)) continue;
            upstreamHops.add(hop);
            if (includeTargetedSteps && !hop.getToStep().chosesTargetSteps()) {
                all.stream().filter(thm -> thm.getFromStep().equals((Object)hop.getToStep())).filter(thm -> !upstreamHops.contains(thm)).forEach(thm -> TransMutators.findUpstreamHops(upstreamHops, all, thm.getToStep(), true));
            }
            TransMutators.findUpstreamHops(upstreamHops, all, hop.getFromStep(), includeTargetedSteps);
        }
    }
}

