/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.parquet.input;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.parquet.ParquetTypeConverter;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class ParquetInputMetaBase
extends BaseFileInputMeta<BaseFileInputAdditionalField, FormatInputFile, ParquetInputField>
implements ResolvableResource {
    @Injection(name="IGNORE_EMPTY_FOLDER")
    boolean ignoreEmptyFolder = false;

    public ParquetInputMetaBase() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new FormatInputFile();
        this.inputFields = new ParquetInputField[0];
    }

    public boolean isIgnoreEmptyFolder() {
        return this.ignoreEmptyFolder;
    }

    public void setIgnoreEmptyFolder(boolean ignoreEmptyFolder) {
        this.ignoreEmptyFolder = ignoreEmptyFolder;
    }

    public String getFilename() {
        if (this.inputFiles != null && ((FormatInputFile)this.inputFiles).fileName != null && ((FormatInputFile)this.inputFiles).fileName.length > 0) {
            return ((FormatInputFile)this.inputFiles).fileName[0];
        }
        return null;
    }

    public String[] getFileNames() {
        if (this.inputFiles != null && ((FormatInputFile)this.inputFiles).fileName != null && ((FormatInputFile)this.inputFiles).fileName.length > 0) {
            return ((FormatInputFile)this.inputFiles).fileName;
        }
        return null;
    }

    public void setFilename(String filename) {
        ((FormatInputFile)this.inputFiles).fileName[0] = filename;
    }

    public void setFilenames(String[] filenames) {
        ((FormatInputFile)this.inputFiles).fileName = filenames;
    }

    public ParquetInputField[] getInputFields() {
        return (ParquetInputField[])this.inputFields;
    }

    public void setInputFields(ParquetInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public void setInputFields(List<ParquetInputField> inputFields) {
        this.inputFields = new ParquetInputField[inputFields.size()];
        this.inputFields = inputFields.toArray((ParquetInputField[])this.inputFields);
    }

    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(1500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"passing_through_fields", (boolean)((FormatInputFile)this.inputFiles).passingThruFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"ignore_empty_folder", (boolean)this.ignoreEmptyFolder));
        retval.append("    <file>").append(Const.CR);
        ((FormatInputFile)this.inputFiles).normalizeAllocation(((FormatInputFile)this.inputFiles).fileName.length);
        for (i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"environment", (String)((FormatInputFile)this.inputFiles).environment[i]));
            if (this.parentStepMeta != null && this.parentStepMeta.getParentTransMeta() != null) {
                this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(((FormatInputFile)this.inputFiles).fileName[i]);
            }
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)((FormatInputFile)this.inputFiles).fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)((FormatInputFile)this.inputFiles).fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)((FormatInputFile)this.inputFiles).excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)((FormatInputFile)this.inputFiles).fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)((FormatInputFile)this.inputFiles).includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < ((ParquetInputField[])this.inputFields).length; ++i) {
            ParquetInputField field = ((ParquetInputField[])this.inputFields)[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getFormatFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getPentahoFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            ParquetSpec.DataType parquetType = field.getParquetType();
            if (parquetType != null && !parquetType.equals((Object)ParquetSpec.DataType.NULL)) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"parquet_type", (String)parquetType.getName()));
            } else {
                retval.append("        ").append(XMLHandler.addTagValue((String)"parquet_type", (String)ParquetTypeConverter.convertToParquetType(field.getTypeDesc())));
            }
            if (field.getStringFormat() != null) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getStringFormat()));
            }
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "ignore_empty_folder", this.ignoreEmptyFolder);
            rep.saveStepAttribute(id_transformation, id_step, "passing_through_fields", ((FormatInputFile)this.inputFiles).passingThruFields);
            if (((FormatInputFile)this.inputFiles).fileName.length != 1 || !((FormatInputFile)this.inputFiles).fileName[0].equalsIgnoreCase("")) {
                for (i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "environment", ((FormatInputFile)this.inputFiles).environment[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "file_name", ((FormatInputFile)this.inputFiles).fileName[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", ((FormatInputFile)this.inputFiles).fileMask[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", ((FormatInputFile)this.inputFiles).excludeFileMask[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "file_required", ((FormatInputFile)this.inputFiles).fileRequired[i]);
                    rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", ((FormatInputFile)this.inputFiles).includeSubFolders[i]);
                }
            }
            for (i = 0; i < ((ParquetInputField[])this.inputFields).length; ++i) {
                ParquetInputField field = ((ParquetInputField[])this.inputFields)[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getFormatFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getPentahoFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                ParquetSpec.DataType parquetType = field.getParquetType();
                if (parquetType != null && !parquetType.equals((Object)ParquetSpec.DataType.NULL)) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "parquet_type", parquetType.getName());
                } else {
                    rep.saveStepAttribute(id_transformation, id_step, i, "parquet_type", ParquetTypeConverter.convertToParquetType(field.getTypeDesc()));
                }
                if (field.getStringFormat() == null) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "format", field.getStringFormat());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        int i;
        Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
        int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        String passThroughFields = XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields");
        String skipIfNoFile = XMLHandler.getTagValue((Node)stepnode, (String)"ignore_empty_folder") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"ignore_empty_folder");
        this.allocateFiles(nrfiles);
        ((FormatInputFile)this.inputFiles).passingThruFields = ValueMetaBase.convertStringToBoolean((String)passThroughFields);
        this.ignoreEmptyFolder = ValueMetaBase.convertStringToBoolean((String)skipIfNoFile);
        for (i = 0; i < nrfiles; ++i) {
            Node envnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"environment", (int)i);
            Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
            Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
            Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
            Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
            Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
            ((FormatInputFile)this.inputFiles).environment[i] = XMLHandler.getNodeValue((Node)envnode);
            ((FormatInputFile)this.inputFiles).fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
            ((FormatInputFile)this.inputFiles).fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            ((FormatInputFile)this.inputFiles).excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
            ((FormatInputFile)this.inputFiles).fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
            ((FormatInputFile)this.inputFiles).includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
        }
        this.inputFields = new ParquetInputField[nrfields];
        for (i = 0; i < nrfields; ++i) {
            Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            ParquetInputField field = new ParquetInputField();
            field.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
            field.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
            field.setPentahoType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
            String parquetType = XMLHandler.getTagValue((Node)fnode, (String)"parquet_type");
            if (parquetType != null && !parquetType.equalsIgnoreCase("null")) {
                field.setParquetType(parquetType);
            } else {
                field.setParquetType(ParquetTypeConverter.convertToParquetType(field.getPentahoType()));
            }
            String stringFormat = XMLHandler.getTagValue((Node)fnode, (String)"format");
            field.setStringFormat(stringFormat == null ? "" : stringFormat);
            ((ParquetInputField[])this.inputFields)[i] = field;
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            this.allocateFiles(nrfiles);
            ((FormatInputFile)this.inputFiles).passingThruFields = rep.getStepAttributeBoolean(id_step, "passing_through_fields");
            this.ignoreEmptyFolder = rep.getStepAttributeBoolean(id_step, "ignore_empty_folder");
            for (int i = 0; i < nrfiles; ++i) {
                ((FormatInputFile)this.inputFiles).environment[i] = rep.getStepAttributeString(id_step, i, "environment");
                ((FormatInputFile)this.inputFiles).fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                ((FormatInputFile)this.inputFiles).fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                ((FormatInputFile)this.inputFiles).excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                ((FormatInputFile)this.inputFiles).fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!"Y".equalsIgnoreCase(((FormatInputFile)this.inputFiles).fileRequired[i])) {
                    ((FormatInputFile)this.inputFiles).fileRequired[i] = "N";
                }
                ((FormatInputFile)this.inputFiles).includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if ("Y".equalsIgnoreCase(((FormatInputFile)this.inputFiles).includeSubFolders[i])) continue;
                ((FormatInputFile)this.inputFiles).includeSubFolders[i] = "N";
            }
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.inputFields = new ParquetInputField[nrfields];
            for (int i = 0; i < nrfields; ++i) {
                ParquetInputField field = new ParquetInputField();
                field.setFormatFieldName(rep.getStepAttributeString(id_step, i, "path"));
                field.setPentahoFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setPentahoType(rep.getStepAttributeString(id_step, i, "field_type"));
                String parquetType = rep.getStepAttributeString(id_step, i, "parquet_type");
                if (parquetType != null && !parquetType.equalsIgnoreCase("null")) {
                    field.setParquetType(parquetType);
                } else {
                    field.setParquetType(ParquetTypeConverter.convertToParquetType(field.getPentahoType()));
                }
                String stringFormat = rep.getStepAttributeString(id_step, i, "format");
                field.setStringFormat(stringFormat == null ? "" : stringFormat);
                ((ParquetInputField[])this.inputFields)[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void allocateFiles(int nrFiles) {
        ((FormatInputFile)this.inputFiles).environment = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileName = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).excludeFileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileRequired = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).includeSubFolders = new String[nrFiles];
    }

    public String getEncoding() {
        return null;
    }

    public void setDefault() {
        this.allocateFiles(0);
        this.inputFields = new ParquetInputField[0];
    }

    public void resolve() {
        if (this.inputFiles != null && ((FormatInputFile)this.inputFiles).fileName != null) {
            for (int i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
                try {
                    String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(((FormatInputFile)this.inputFiles).fileName[i]);
                    FileObject fileObject = KettleVFS.getFileObject((String)realFileName);
                    if (!AliasedFileObject.isAliasedFile((FileObject)fileObject)) continue;
                    ((FormatInputFile)this.inputFiles).fileName[i] = ((AliasedFileObject)fileObject).getAELSafeURIString();
                    continue;
                }
                catch (KettleFileException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            for (int i = 0; i < ((ParquetInputField[])this.inputFields).length; ++i) {
                ParquetInputField field = ((ParquetInputField[])this.inputFields)[i];
                String value = space.environmentSubstitute(field.getPentahoFieldName());
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)value, (int)field.getPentahoType());
                v.setOrigin(origin);
                rowMeta.addValueMeta(v);
            }
        }
        catch (KettlePluginException e) {
            throw new KettleStepException("Unable to create value type", (Throwable)e);
        }
    }
}

