/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.parquet;

import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;

public class ParquetTypeConverter {
    public static String convertToParquetType(String pdiType) {
        int pdiTypeId = -1;
        for (int i = 0; i < ValueMetaInterface.typeCodes.length; ++i) {
            if (!ValueMetaInterface.typeCodes[i].equals(pdiType)) continue;
            pdiTypeId = i;
            break;
        }
        return ParquetTypeConverter.convertToParquetType(pdiTypeId);
    }

    public static String convertToParquetType(int pdiType) {
        switch (pdiType) {
            case 2: 
            case 10: {
                return ParquetSpec.DataType.UTF8.getName();
            }
            case 9: {
                return ParquetSpec.DataType.TIMESTAMP_MILLIS.getName();
            }
            case 8: {
                return ParquetSpec.DataType.BINARY.getName();
            }
            case 6: {
                return ParquetSpec.DataType.DECIMAL.getName();
            }
            case 4: {
                return ParquetSpec.DataType.BOOLEAN.getName();
            }
            case 3: {
                return ParquetSpec.DataType.DATE.getName();
            }
            case 5: {
                return ParquetSpec.DataType.INT_64.getName();
            }
            case 1: {
                return ParquetSpec.DataType.DOUBLE.getName();
            }
        }
        return ParquetSpec.DataType.NULL.getName();
    }
}

