/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.big.data.kettle.plugins.formats.BaseFormatInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;

public class AvroInputField
extends BaseFormatInputField
implements IAvroInputField {
    private List<String> pathParts;
    private List<String> indexedVals = new ArrayList<String>();
    private boolean m_isValid;
    protected String m_cleansedVariableName;
    protected String m_resolvedFieldName;
    protected ValueMetaInterface m_fieldVM;
    public String m_variableName = "";
    private ValueMeta tempValueMeta;
    private List<String> tempParts;
    protected static Class<?> PKG = AvroInputMetaBase.class;
    private int outputIndex;

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public void setPathParts(List<String> pathParts) {
        this.pathParts = pathParts;
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    public ValueMeta getTempValueMeta() {
        return this.tempValueMeta;
    }

    public void setTempValueMeta(ValueMeta tempValueMeta) {
        this.tempValueMeta = tempValueMeta;
    }

    public List<String> getTempParts() {
        return this.tempParts;
    }

    public void setTempParts(List<String> tempParts) {
        this.tempParts = tempParts;
    }

    public void setIndexedVals(List<String> mindexedVals) {
        this.indexedVals = mindexedVals;
    }

    private void initIndexedVals() {
        int bracketPos = this.formatFieldName.indexOf(91);
        if (this.indexedVals.isEmpty() && bracketPos > -1) {
            int closeBracketPos = this.formatFieldName.indexOf(93);
            String values = this.formatFieldName.substring(bracketPos + 1, closeBracketPos);
            this.indexedVals = Arrays.asList(values.split("\\s*,\\s*"));
        }
    }

    public List<String> getIndexedVals() {
        this.initIndexedVals();
        return this.indexedVals;
    }

    public String getIndexedValues() {
        return String.join((CharSequence)" , ", this.getIndexedVals());
    }

    public void setIndexedValues(String indexedValues) {
        this.setIndexedVals(Arrays.asList(indexedValues.split("\\s*,\\s*")));
    }

    public String getAvroFieldName() {
        return this.formatFieldName;
    }

    @Override
    public void setFormatFieldName(String formatFieldName) {
        this.setAvroFieldName(formatFieldName);
    }

    public void setAvroFieldName(String avroFieldName) {
        this.formatFieldName = avroFieldName;
        this.initIndexedVals();
    }

    public AvroSpec.DataType getAvroType() {
        return AvroSpec.DataType.getDataType((int)this.getFormatType());
    }

    public void setAvroType(AvroSpec.DataType avroType) {
        this.setFormatType(avroType.getId());
    }

    @Injection(name="AVRO_TYPE", group="FIELDS")
    public void setAvroType(String avroType) {
        for (AvroSpec.DataType tmpType : AvroSpec.DataType.values()) {
            if (!tmpType.toString().equalsIgnoreCase(avroType)) continue;
            this.setFormatType(tmpType.getId());
            break;
        }
    }

    public String getDisplayableAvroFieldName() {
        return this.formatFieldName;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.getPentahoType());
    }

    private void addIndexToFormatFieldName() {
        int bracketPos = this.formatFieldName.indexOf("[");
        if (bracketPos > 0 && !this.indexedVals.isEmpty()) {
            this.formatFieldName = this.formatFieldName.substring(0, bracketPos) + "[" + this.getIndexedValues() + "]";
        }
    }
}

