/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulGrid;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.SwtAlign;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.swt.tags.SwtColumns;
import org.pentaho.ui.xul.swt.tags.SwtRows;
import org.pentaho.ui.xul.util.Orient;

public class SwtGrid
extends AbstractSwtXulContainer
implements XulGrid {
    private static final Log logger = LogFactory.getLog(SwtGrid.class);
    private SwtRows rows;
    private SwtColumns cols;
    private String background;
    private Composite grid;
    private XulDomContainer domContainer;

    public SwtGrid(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("grid");
        this.domContainer = domContainer;
        int style = 0;
        if (self.getAttributeValue("border") != null) {
            style = 2048;
        }
        this.grid = new Composite((Composite)parent.getManagedObject(), style);
        this.grid.setBackgroundMode(1);
        this.setManagedObject(this.grid);
    }

    @Override
    public void addChild(Element e) {
        super.addChild(e);
        if (e instanceof SwtRows) {
            this.rows = (SwtRows)e;
        } else if (e instanceof SwtColumns) {
            this.cols = (SwtColumns)e;
        }
    }

    @Override
    public void addChildAt(Element c, int pos) {
        super.addChildAt(c, pos);
        if (c instanceof SwtRows) {
            this.rows = (SwtRows)c;
        } else if (c instanceof SwtColumns) {
            this.cols = (SwtColumns)c;
        }
    }

    @Override
    public void layout() {
        if (this.getChildNodes().size() < 2) {
            logger.warn((Object)"Grid does not contain Column and Row children");
            return;
        }
        XulComponent columns = (XulComponent)this.getChildNodes().get(0);
        XulComponent rows = (XulComponent)this.getChildNodes().get(1);
        int totalFlex = 0;
        int thisFlex = 0;
        boolean everyChildIsFlexing = true;
        for (Object child : this.cols.getChildNodes()) {
            thisFlex = ((SwtElement)((Object)child)).getFlex();
            if (thisFlex <= 0) {
                everyChildIsFlexing = false;
            }
            totalFlex += thisFlex;
        }
        Composite container = (Composite)this.getManagedObject();
        int columnCount = this.cols.getChildNodes().size() + totalFlex;
        GridLayout layout = new GridLayout(columnCount, everyChildIsFlexing);
        if (this.getPadding() > -1) {
            layout.marginWidth = this.getPadding();
            layout.marginHeight = this.getPadding();
        }
        if (this.getSpacing() > -1) {
            layout.horizontalSpacing = this.getSpacing();
            layout.verticalSpacing = this.getSpacing();
        }
        container.setLayout((Layout)layout);
        boolean atLeastOneRowIsFlexed = false;
        for (XulComponent row : rows.getChildNodes()) {
            if (row.getFlex() >= 1) {
                atLeastOneRowIsFlexed = true;
            }
            for (Element cell : row.getChildNodes()) {
                SwtElement swtChild = (SwtElement)cell;
                Object mo = swtChild.getManagedObject();
                if (mo == null || !(mo instanceof Control) || swtChild instanceof XulDialog) continue;
                Control c = (Control)swtChild.getManagedObject();
                GridData data = new GridData();
                data.horizontalSpan = ((XulComponent)this.cols.getChildNodes().get(row.getChildNodes().indexOf(cell))).getFlex() + 1;
                data.verticalSpan = row.getFlex() + 1;
                if (row.getFlex() >= 1) {
                    data.verticalAlignment = 4;
                    data.grabExcessVerticalSpace = true;
                }
                if (swtChild.getFlex() > 0 && swtChild.getWidth() == 0) {
                    data.grabExcessHorizontalSpace = true;
                    data.horizontalAlignment = 4;
                }
                if (swtChild.getWidth() > 0) {
                    data.widthHint = swtChild.getWidth();
                }
                if (swtChild.getHeight() > 0) {
                    data.heightHint = swtChild.getHeight();
                }
                if (swtChild.getFlex() <= 0 && swtChild.getAlign() != null) {
                    SwtAlign swtAlign = SwtAlign.valueOf(swtChild.getAlign().toString());
                    switch (swtAlign) {
                        case START: {
                            data.horizontalAlignment = 1;
                            break;
                        }
                        case END: {
                            data.horizontalAlignment = 3;
                            break;
                        }
                        case CENTER: {
                            data.horizontalAlignment = 2;
                        }
                    }
                }
                if (this.orient.equals((Object)Orient.HORIZONTAL)) {
                    if (swtChild.getHeight() < 0) {
                        data.grabExcessVerticalSpace = true;
                    }
                } else if (swtChild.getWidth() < 0) {
                    data.grabExcessHorizontalSpace = true;
                }
                c.setLayoutData((Object)data);
            }
        }
        if (!atLeastOneRowIsFlexed) {
            // empty if block
        }
        container.layout(true);
        this.initialized = true;
    }

    public void update() {
        this.layout();
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
        java.awt.Color c = java.awt.Color.decode(bgcolor);
        this.grid.setBackground(new Color((Device)this.grid.getDisplay(), c.getRed(), c.getGreen(), c.getBlue()));
        this.grid.setBackgroundMode(1);
    }
}

