/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class MessageDialogBase
extends SwtElement {
    protected List<XulDialogCallback<String>> callbacks = new ArrayList<XulDialogCallback<String>>();
    private Shell parentObject;
    protected int acceptBtn = DialogConstant.YES.getValue();
    protected int cancelBtn = DialogConstant.NO.getValue();
    protected String title;
    protected String message;
    private Log logger = LogFactory.getLog(MessageDialogBase.class);
    protected int icon = 0;

    public MessageDialogBase(String tagName) {
        super(tagName);
    }

    public void addDialogCallback(XulDialogCallback callback) {
        this.callbacks.add((XulDialogCallback<String>)callback);
    }

    public void removeDialogCallback(XulDialogCallback callback) {
        this.callbacks.remove(callback);
    }

    protected Shell getParentObject() {
        if (this.parentObject != null) {
            return this.parentObject;
        }
        if (this.getParent() instanceof XulRoot) {
            return (Shell)((XulRoot)this.getParent()).getRootObject();
        }
        if (this.getParent() != null) {
            return (Shell)this.getParent().getManagedObject();
        }
        return Display.getCurrent().getActiveShell();
    }

    public Object[] getButtons() {
        return null;
    }

    public void setButtons(Object[] buttons) {
        block4: for (Object o : buttons) {
            if (o instanceof String) {
                o = "ACCEPT".equalsIgnoreCase((String)o) ? DialogConstant.OK : ("CANCEL".equalsIgnoreCase((String)o) ? DialogConstant.CANCEL : o);
            }
            DialogConstant con = (DialogConstant)((Object)o);
            switch (con) {
                case YES: 
                case OK: {
                    this.acceptBtn = con.getValue();
                    continue block4;
                }
                case NO: 
                case CANCEL: {
                    this.cancelBtn = con.getValue();
                }
            }
        }
    }

    public Object getIcon() {
        return null;
    }

    protected void notifyListeners(Integer code) {
        XulDialogCallback.Status status = XulDialogCallback.Status.CANCEL;
        switch (code) {
            case 32: 
            case 64: {
                status = XulDialogCallback.Status.ACCEPT;
                break;
            }
            case 128: 
            case 256: {
                status = XulDialogCallback.Status.CANCEL;
            }
        }
        for (XulDialogCallback<String> callback : this.callbacks) {
            callback.onClose((XulComponent)this, status, null);
        }
    }

    public void setModalParent(Object parent) {
        this.parentObject = (Shell)parent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCancelLabel(String str) {
        this.logger.debug((Object)"Cannot set button label text in SWT. Use setButtons() instead");
    }

    public void setAcceptLabel(String str) {
        this.logger.debug((Object)"Cannot set button label text in SWT. Use setButtons() instead");
    }

    public void setIcon(Object icon) {
        if (!(icon instanceof DialogConstant)) {
            this.logger.error((Object)"Icon needs to be an DialogConstant value");
            return;
        }
        icon = ((DialogConstant)((Object)icon)).getValue();
    }

    public void setScrollable(boolean scroll) {
        this.logger.error((Object)"SWT does not support scrolling of message area.");
    }
}

