/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.Duration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.ehcache.jcache.JCacheCacheWriterAdapter;
import org.ehcache.jcache.JCacheConfiguration;
import org.ehcache.jcache.JCacheEntry;
import org.ehcache.jcache.JCacheListenerAdapter;
import org.ehcache.jcache.JCacheManager;

public class JCache<K, V>
implements Cache<K, V> {
    private static final Object NOT_THERE = new Object();
    private final JCacheConfiguration<K, V> cfg;
    private final Ehcache ehcache;
    private final JCacheManager cacheManager;
    private final CacheLoader<K, V> cacheLoader;
    private final CacheWriter cacheWriter;
    private volatile boolean closed = false;

    public JCache(JCacheManager cacheManager, JCacheConfiguration<K, V> cfg, Ehcache ehcache) {
        if (ehcache == null) {
            throw new NullPointerException();
        }
        this.cacheManager = cacheManager;
        this.cfg = cfg;
        this.ehcache = ehcache;
        Factory<CacheLoader<K, V>> cacheLoaderFactory = cfg.getCacheLoaderFactory();
        this.cacheLoader = cacheLoaderFactory != null ? (CacheLoader)cacheLoaderFactory.create() : null;
        Factory<CacheWriter<K, V>> cacheWriterFactory = cfg.getCacheWriterFactory();
        this.cacheWriter = cacheWriterFactory != null ? (CacheWriter)cacheWriterFactory.create() : null;
        ehcache.registerCacheWriter(new JCacheCacheWriterAdapter<K, V>(this.cacheWriter, cfg.getKeyType(), cfg.getValueType()));
        Iterable<CacheEntryListenerConfiguration<K, V>> cacheEntryListenerConfigurations = cfg.getInitialCacheEntryListenerConfigurations();
        if (cacheEntryListenerConfigurations != null) {
            for (CacheEntryListenerConfiguration<K, V> listenerCfg : cacheEntryListenerConfigurations) {
                this.registerCacheEntryListener(listenerCfg);
            }
        }
    }

    public V get(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        Element element = this.getElement(key);
        if (element == null) {
            V value = null;
            if (this.cfg.isReadThrough()) {
                value = this.load(key);
            }
            return value;
        }
        return this.cfg.getValueType().cast(element.getObjectValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V load(K key) {
        Object value;
        this.ehcache.acquireWriteLockOnKey(key);
        Element e = this.ehcache.get(key);
        if (e != null) {
            return (V)e.getObjectValue();
        }
        try {
            try {
                value = this.cacheLoader.load(key);
            }
            catch (Exception ex) {
                throw new CacheLoaderException((Throwable)ex);
            }
            if (value != null) {
                this.putWithoutWriter(key, value);
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
        return (V)value;
    }

    private Element getElement(K key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        Duration expiryForUpdate = this.cfg.getExpiryPolicy().getExpiryForAccess();
        if (expiryForUpdate != null && expiryForUpdate.isZero()) {
            this.ehcache.removeElement(element);
        }
        return element;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        HashMap result = new HashMap();
        Map all = this.ehcache.getAll(keys);
        for (Map.Entry entry : all.entrySet()) {
            Element e = (Element)entry.getValue();
            Object key = entry.getKey();
            if (key == null) continue;
            Object value = null;
            if (e != null) {
                value = e.getObjectValue();
            } else if (this.cfg.isReadThrough()) {
                value = this.load(key);
            }
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public boolean containsKey(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        return this.ehcache.isKeyInCache(key);
    }

    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        this.cacheManager.getExecutorService().submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                for (Object key : keys) {
                    try {
                        JCache.this.ehcache.acquireWriteLockOnKey(key);
                        try {
                            Object value;
                            if (JCache.this.ehcache.isKeyInCache(key) && !replaceExistingValues || (value = JCache.this.cacheLoader.load(key)) == null) continue;
                            JCache.this.putWithoutWriter(key, value);
                        }
                        finally {
                            JCache.this.ehcache.releaseWriteLockOnKey(key);
                        }
                    }
                    catch (Exception e) {
                        if (completionListener != null) {
                            completionListener.onException((Exception)new CacheLoaderException((Throwable)e));
                        }
                        return null;
                    }
                }
                if (completionListener != null) {
                    completionListener.onCompletion();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            boolean inCache = this.ehcache.isKeyInCache(key);
            Duration expiry = inCache ? this.cfg.getExpiryPolicy().getExpiryForUpdate() : this.cfg.getExpiryPolicy().getExpiryForCreation();
            Element element = new Element(key, value);
            if (this.setTimeTo(expiry, element)) {
                this.putAndWriteIfNeeded(element);
            } else if (inCache) {
                this.removeAndWriteIfNeeded(key);
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putWithoutWriter(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            boolean inCache = this.ehcache.isKeyInCache(key);
            Duration expiry = inCache ? this.cfg.getExpiryPolicy().getExpiryForUpdate() : this.cfg.getExpiryPolicy().getExpiryForCreation();
            Element element = new Element(key, value);
            if (this.setTimeTo(expiry, element)) {
                this.ehcache.put(element);
            } else if (inCache) {
                this.ehcache.remove(key);
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    private boolean setTimeTo(Duration duration, Element element) {
        if (duration != null) {
            if (duration.isZero()) {
                return false;
            }
            if (duration.isEternal()) {
                element.setEternal(true);
            } else {
                int d = (int)TimeUnit.SECONDS.convert(duration.getDurationAmount(), duration.getTimeUnit());
                element.setTimeToLive(d == 0 ? 1 : d);
                element.setTimeToIdle(d);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element previousElement = this.ehcache.get(key);
            Element element = new Element(key, value);
            boolean inCache = this.ehcache.isKeyInCache(key);
            Duration expiry = inCache ? this.cfg.getExpiryPolicy().getExpiryForUpdate() : this.cfg.getExpiryPolicy().getExpiryForCreation();
            if (this.setTimeTo(expiry, element)) {
                this.putAndWriteIfNeeded(element);
            } else if (inCache) {
                this.removeAndWriteIfNeeded(key);
            }
            Object object = previousElement == null ? null : previousElement.getObjectValue();
            return (V)object;
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    private boolean removeAndWriteIfNeeded(K key) {
        if (this.cfg.isWriteThrough()) {
            this.ehcache.acquireWriteLockOnKey(key);
            Element previous = this.ehcache.getQuiet(key);
            try {
                return this.ehcache.removeWithWriter(key);
            }
            catch (RuntimeException e) {
                if (previous != null) {
                    this.ehcache.putQuiet(previous);
                }
                throw new CacheWriterException((Throwable)e);
            }
        }
        if (this.ehcache.isKeyInCache(key)) {
            return this.ehcache.remove(key);
        }
        return false;
    }

    private void putAndWriteIfNeeded(Element element) {
        if (this.cfg.isWriteThrough()) {
            try {
                this.ehcache.putWithWriter(element);
            }
            catch (RuntimeException e) {
                this.ehcache.removeElement(element);
                throw new CacheWriterException((Throwable)e);
            }
        } else {
            this.ehcache.put(element);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkNotClosed();
        HashSet<Element> elements = new HashSet<Element>(map.size(), 1.0f);
        HashSet<JCacheEntry<K, V>> entries = new HashSet<JCacheEntry<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                throw new NullPointerException();
            }
            Element element = new Element(entry.getKey(), entry.getValue());
            Duration expiry = this.ehcache.isKeyInCache(entry.getKey()) ? this.cfg.getExpiryPolicy().getExpiryForUpdate() : this.cfg.getExpiryPolicy().getExpiryForCreation();
            if (this.setTimeTo(expiry, element)) {
                elements.add(element);
                if (!this.cfg.isWriteThrough()) continue;
                entries.add(new JCacheEntry<K, V>(element, this.cfg.getKeyType(), this.cfg.getValueType()));
                continue;
            }
            this.ehcache.remove(entry.getKey());
        }
        for (Element element : elements) {
            this.ehcache.put(element);
        }
        if (this.cfg.isWriteThrough()) {
            try {
                try {
                    this.cacheWriter.writeAll(entries);
                }
                catch (RuntimeException e) {
                    throw new CacheWriterException((Throwable)e);
                }
            }
            catch (Exception e) {
                for (Cache.Entry entry : entries) {
                    this.ehcache.remove(entry.getKey());
                }
                throw new CacheWriterException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            if (!this.ehcache.isKeyInCache(key)) {
                Element element = new Element(key, value);
                Duration expiryForCreation = this.cfg.getExpiryPolicy().getExpiryForCreation();
                if (this.setTimeTo(expiryForCreation, element)) {
                    this.putAndWriteIfNeeded(element);
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
        return false;
    }

    public boolean remove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        return this.removeAndWriteIfNeeded(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V oldValue) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (oldValue == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            if (this.ehcache.isKeyInCache(key)) {
                Duration expiryForAccess;
                Element e = this.ehcache.get(key);
                if (e != null && e.getObjectValue().equals(oldValue)) {
                    this.removeAndWriteIfNeeded(key);
                    boolean bl = true;
                    return bl;
                }
                if (e != null && (expiryForAccess = this.cfg.getExpiryPolicy().getExpiryForAccess()) != null && expiryForAccess.isZero()) {
                    this.removeAndWriteIfNeeded(key);
                }
            } else {
                this.ehcache.get(NOT_THERE);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element previousElement = this.ehcache.get(key);
            this.removeAndWriteIfNeeded(key);
            Object object = previousElement == null ? null : previousElement.getObjectValue();
            return (V)object;
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        Element element = new Element(key, newValue);
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element current = this.ehcache.get(key);
            if (current != null) {
                if (!current.getObjectValue().equals(oldValue)) {
                    Duration expiryForAccess = this.cfg.getExpiryPolicy().getExpiryForAccess();
                    if (expiryForAccess != null && expiryForAccess.isZero()) {
                        this.ehcache.remove(key);
                    }
                } else {
                    Duration expiry = this.cfg.getExpiryPolicy().getExpiryForUpdate();
                    if (this.setTimeTo(expiry, element)) {
                        this.ehcache.put(new Element(key, newValue));
                        boolean bl = true;
                        return bl;
                    }
                    this.ehcache.remove(key);
                }
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element element = new Element(key, value);
            boolean inCache = this.ehcache.isKeyInCache(key);
            if (inCache) {
                this.ehcache.get(key);
                Duration expiry = this.cfg.getExpiryPolicy().getExpiryForUpdate();
                if (this.setTimeTo(expiry, element)) {
                    this.putAndWriteIfNeeded(element);
                    boolean bl = true;
                    return bl;
                }
                this.removeAndWriteIfNeeded(key);
                boolean bl = true;
                return bl;
            }
            this.ehcache.get(NOT_THERE);
            boolean bl = false;
            return bl;
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndReplace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element element;
            Duration expiry;
            Element previous = this.ehcache.get(key);
            if (previous != null && this.setTimeTo(expiry = this.cfg.getExpiryPolicy().getExpiryForUpdate(), element = new Element(key, value))) {
                this.putAndWriteIfNeeded(element);
                Object object = previous.getObjectValue();
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        this.checkNotClosed();
        if (this.cfg.isWriteThrough()) {
            for (K key : keys) {
                this.ehcache.acquireWriteLockOnKey(key);
                try {
                    Element previous = this.ehcache.getQuiet(key);
                    try {
                        this.ehcache.removeWithWriter(key);
                    }
                    catch (RuntimeException e) {
                        if (previous != null) {
                            this.ehcache.putQuiet(previous);
                        }
                        throw new CacheWriterException((Throwable)e);
                    }
                }
                finally {
                    this.ehcache.releaseWriteLockOnKey(key);
                }
            }
        } else if (this.cfg.isStatisticsEnabled()) {
            for (K key : keys) {
                if (!this.ehcache.isKeyInCache(key)) continue;
                this.ehcache.remove(key);
            }
        } else {
            this.ehcache.removeAll(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.checkNotClosed();
        if (this.cfg.isWriteThrough()) {
            for (Object key : this.ehcache.getKeys()) {
                this.ehcache.acquireWriteLockOnKey(key);
                Element previous = this.ehcache.getQuiet(key);
                try {
                    try {
                        this.ehcache.removeWithWriter(key);
                    }
                    catch (RuntimeException e) {
                        if (previous != null) {
                            this.ehcache.putQuiet(previous);
                        }
                        throw new CacheWriterException((Throwable)e);
                    }
                }
                finally {
                    this.ehcache.releaseWriteLockOnKey(key);
                }
            }
        } else if (this.cfg.isStatisticsEnabled()) {
            for (Object o : this.ehcache.getKeys()) {
                Element element = this.ehcache.getQuiet(o);
                if (element == null) continue;
                if (element.getTimeToLive() == 1 && element.getTimeToIdle() == 0) {
                    this.ehcache.removeQuiet(element.getObjectKey());
                    continue;
                }
                this.ehcache.remove(element.getObjectKey());
            }
        } else {
            this.ehcache.removeAll();
        }
    }

    public void clear() {
        this.checkNotClosed();
        this.ehcache.removeAll();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isAssignableFrom(this.cfg.getClass())) {
            return (C)((Configuration)clazz.cast(this.cfg));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        Object outcome;
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        this.ehcache.acquireWriteLockOnKey(key);
        try {
            Element element = this.ehcache.get(key);
            try {
                boolean fromLoader = false;
                if (element == null && this.cfg.isReadThrough() && this.load(key) != null) {
                    element = this.ehcache.get(key);
                    fromLoader = true;
                }
                JMutableEntry entry = new JMutableEntry(this, element, key, fromLoader);
                outcome = entryProcessor.process(entry, arguments);
                entry.apply(this);
            }
            catch (RuntimeException t) {
                if (t instanceof CacheException) {
                    throw t;
                }
                throw new EntryProcessorException((Throwable)t);
            }
        }
        finally {
            this.ehcache.releaseWriteLockOnKey(key);
        }
        return (T)outcome;
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap<K, 2> results = new HashMap<K, 2>();
        for (K key : keys) {
            final T result = this.invoke(key, entryProcessor, arguments);
            if (result == null) continue;
            results.put(key, new EntryProcessorResult<T>(){

                public T get() throws EntryProcessorException {
                    return result;
                }
            });
        }
        return results;
    }

    public String getName() {
        return this.ehcache.getName();
    }

    public CacheManager getCacheManager() {
        this.checkNotClosed();
        return this.cacheManager;
    }

    public void close() {
        this.cacheManager.shutdown(this);
    }

    void shutdown() {
        this.closed = true;
        this.ehcache.dispose();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.ehcache.getClass())) {
            return clazz.cast(this.ehcache);
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Factory factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        CacheEntryListener cacheEntryListener = (CacheEntryListener)factory.create();
        JCacheListenerAdapter<K, V> cacheEventListener = new JCacheListenerAdapter<K, V>(cacheEntryListener, this, cacheEntryListenerConfiguration);
        if (!this.cfg.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration, cacheEventListener)) {
            throw new IllegalArgumentException();
        }
        this.ehcache.getCacheEventNotificationService().registerListener(cacheEventListener);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        JCacheListenerAdapter<K, V> adapter = this.cfg.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        if (adapter != null) {
            this.ehcache.getCacheEventNotificationService().unregisterListener(adapter);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNotClosed();
        return new JEntryIterator(this);
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    private static class JMutableEntry<K, V>
    implements MutableEntry<K, V> {
        private final JCache<K, V> jCache;
        private final K key;
        private final boolean fromLoader;
        private final V initialValue;
        private volatile V newValue;
        private volatile boolean deleted;
        private volatile boolean skipDelete;

        public JMutableEntry(JCache<K, V> jCache, Element element, K key, boolean fromLoader) {
            this.jCache = jCache;
            this.key = key;
            this.fromLoader = fromLoader;
            this.initialValue = element != null ? element.getObjectValue() : null;
            this.newValue = this.initialValue;
        }

        public boolean exists() {
            return !this.deleted && this.newValue != null;
        }

        public void remove() {
            this.skipDelete = this.initialValue == null && this.newValue != null;
            this.newValue = null;
            this.deleted = true;
        }

        public void setValue(V value) {
            if (value == null) {
                throw new EntryProcessorException();
            }
            this.deleted = false;
            this.newValue = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            Duration expiryForAccess;
            if (this.newValue != this.initialValue) {
                return this.newValue;
            }
            if (this.initialValue != null && !this.fromLoader && (expiryForAccess = ((JCache)this.jCache).cfg.getExpiryPolicy().getExpiryForAccess()) != null && expiryForAccess.isZero()) {
                this.remove();
            }
            return this.initialValue;
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException("Implement me!");
        }

        void apply(JCache<K, V> jCache) {
            if (this.deleted && !this.skipDelete) {
                jCache.remove(this.key);
            }
            if (this.newValue != this.initialValue && this.newValue != null) {
                jCache.put(this.key, this.newValue);
            }
        }
    }

    private static class JEntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<K> keyIterator;
        private final JCache<K, V> jCache;
        private Cache.Entry<K, V> next;
        private Cache.Entry<K, V> current;

        public JEntryIterator(JCache jCache) {
            this.jCache = jCache;
            this.keyIterator = jCache.ehcache.getKeys().iterator();
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            Duration expiryForAccess = ((JCache)this.jCache).cfg.getExpiryPolicy().getExpiryForAccess();
            this.advance();
            if (expiryForAccess != null && expiryForAccess.isZero()) {
                this.remove();
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ((JCache)this.jCache).ehcache.acquireWriteLockOnKey(this.current.getKey());
            try {
                Element element = ((JCache)this.jCache).ehcache.getQuiet(this.current.getKey());
                if (element != null && element.getObjectValue().equals(this.current.getValue())) {
                    ((JCache)this.jCache).removeAndWriteIfNeeded(this.current.getKey());
                }
            }
            finally {
                ((JCache)this.jCache).ehcache.releaseWriteLockOnKey(this.current.getKey());
            }
        }

        private void advance() {
            this.next = null;
            while (this.keyIterator.hasNext() && this.next == null) {
                Element e = ((JCache)this.jCache).getElement(this.keyIterator.next());
                if (e == null) continue;
                this.next = new JCacheEntry(e, ((JCache)this.jCache).cfg.getKeyType(), ((JCache)this.jCache).cfg.getValueType());
            }
        }
    }
}

