/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.pentaho.reporting.libraries.designtime.swing.ColorCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;

public class ColorComboBox
extends SmartComboBox {
    public ColorComboBox() {
        DefaultComboBoxModel<Color> model = new DefaultComboBoxModel<Color>(ColorUtility.getPredefinedExcelColors());
        model.insertElementAt(null, 0);
        model.setSelectedItem(null);
        this.setModel(model);
        this.setRenderer(new ColorCellRenderer());
        int height1 = this.getPreferredSize().height;
        this.setMaximumSize(new Dimension(height1 * 4, height1));
        this.setFocusable(false);
        boolean isGTK = this.isGTKLookAndFeel();
        this.setEditable(isGTK);
        if (isGTK) {
            this.setEditor(new CustomGTKComboBoxEditor());
        }
    }

    public void setValueFromModel(Color o) {
        Action old = this.getAction();
        this.setAction(null);
        this.setSelectedItem(o);
        this.setAction(old);
    }

    public Color getValueFromModel() {
        return (Color)this.getSelectedItem();
    }

    private boolean isGTKLookAndFeel() {
        return "GTK".equalsIgnoreCase(UIManager.getLookAndFeel().getID());
    }

    private class CustomGTKComboBoxEditor
    extends BasicComboBoxEditor {
        private JLabel label = new JLabel();
        private JPanel panel = new JPanel();
        private Object selectedItem;

        public CustomGTKComboBoxEditor() {
            this.label.setOpaque(false);
            this.panel.setLayout(new GridBagLayout());
            this.panel.add(this.label);
            this.panel.setOpaque(true);
            this.panel.setBorder(BorderFactory.createCompoundBorder(new MatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY), new EtchedBorder()));
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        @Override
        public Object getItem() {
            return this.selectedItem;
        }

        @Override
        public void setItem(Object item) {
            this.selectedItem = item;
            Color color = (Color)item;
            String txt = color == null ? Messages.getInstance().getString("ColorCellRenderer.Automatic") : ColorUtility.toAttributeValue(color);
            this.label.setText(txt);
            if (color == null) {
                color = Color.WHITE;
            }
            this.label.setBackground(color);
            this.label.setForeground(ColorUtility.getBrightness(color) > 167 ? Color.BLACK : Color.WHITE);
            this.panel.setBackground(color);
        }
    }
}

