/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_PATIENT_OBSERVATION;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OPU_R25_PATIENT
extends AbstractGroup {
    public OPU_R25_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(OPU_R25_PATIENT_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OPU_R25_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_PATIENT_OBSERVATION getPATIENT_OBSERVATION() {
        OPU_R25_PATIENT_OBSERVATION ret = null;
        try {
            ret = (OPU_R25_PATIENT_OBSERVATION)this.get("PATIENT_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_PATIENT_OBSERVATION getPATIENT_OBSERVATION(int rep) {
        OPU_R25_PATIENT_OBSERVATION ret = null;
        try {
            ret = (OPU_R25_PATIENT_OBSERVATION)this.get("PATIENT_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATIENT_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATIENT_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATIENT_OBSERVATION(OPU_R25_PATIENT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_OBSERVATION", (Structure)structure, rep);
    }

    public OPU_R25_PATIENT_OBSERVATION insertPATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_OBSERVATION)super.insertRepetition("PATIENT_OBSERVATION", rep);
    }

    public OPU_R25_PATIENT_OBSERVATION removePATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_OBSERVATION)super.removeRepetition("PATIENT_OBSERVATION", rep);
    }
}

