/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.deployer.archive.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.json.simple.parser.JSONParser;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPackageURLConnection
extends URLConnection {
    public static final String URL_PROTOCOL = "pentaho-webpackage";
    public static final String PACKAGE_JSON = "package.json";
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(5, r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        thread.setName("WebjarsURLConnection pool");
        return thread;
    });
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    Future<Void> transform_thread;

    public WebPackageURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            URLConnection urlConnection = this.url.openConnection();
            urlConnection.connect();
            InputStream originalInputStream = urlConnection.getInputStream();
            this.transform_thread = EXECUTOR.submit(new WebPackageTransformer(this.url, originalInputStream, pipedOutputStream));
            return pipedInputStream;
        }
        catch (Exception e) {
            this.logger.error(this.getURL().toString() + ": Error opening url");
            throw new IOException("Error opening url", e);
        }
    }

    private static class WebPackageTransformer
    implements Callable<Void> {
        private static final String DEBUG_MESSAGE_FAILED_WRITING = "Problem transferring Jar content, probably JarOutputStream was already closed.";
        private static final int BYTES_BUFFER_SIZE = 4096;
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final URL url;
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private JarOutputStream jarOutputStream;
        private Path absoluteTempPath;
        private String resourcesFolderName;
        private Path absoluteTempResourcesPath;

        WebPackageTransformer(URL url, InputStream inputStream, PipedOutputStream outputStream) {
            this.url = url;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.transform();
            }
            catch (Exception e) {
                this.logger.error(this.url.toString() + ": Error Transforming package", (Throwable)e);
                this.outputStream.close();
                throw e;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transform() throws IOException {
            this.init();
            try {
                ArrayList<String> capabilities = new ArrayList<String>();
                List<String> requirements = null;
                if (this.url.getProtocol().equals("jardir") || this.url.getProtocol().equals("file") && this.url.getPath().endsWith(".zip")) {
                    this.processZipArchive(capabilities, requirements);
                } else {
                    this.processTgzArchive(capabilities, requirements);
                }
                Manifest manifest = this.createManifest();
                if (!capabilities.isEmpty()) {
                    manifest.getMainAttributes().put(new Attributes.Name("Provide-Capability"), String.join((CharSequence)", ", capabilities));
                }
                this.jarOutputStream = new JarOutputStream(this.outputStream, manifest);
                Collection scrFiles = FileUtils.listFiles((File)this.absoluteTempPath.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                for (File srcFile : scrFiles) {
                    String relSrcFilePath = FilenameUtils.separatorsToUnix((String)this.absoluteTempPath.relativize(srcFile.toPath()).toString());
                    this.copyFileToZip(this.jarOutputStream, relSrcFilePath, srcFile);
                }
                try {
                    this.jarOutputStream.closeEntry();
                    this.outputStream.flush();
                    this.jarOutputStream.close();
                }
                catch (IOException ioexception) {
                    this.logger.debug(DEBUG_MESSAGE_FAILED_WRITING, (Throwable)ioexception);
                }
            }
            catch (IOException e) {
                this.logger.debug(": Pipe is closed, no need to continue.");
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)this.absoluteTempPath.toFile());
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processZipArchive(List<String> capabilities, List<String> requirements) throws IOException {
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry entry;
                zipInputStream = new ZipInputStream(this.inputStream);
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (!entry.isDirectory() && !name.startsWith("__MACOSX/")) {
                        this.processArchiveEntry(zipInputStream, name, capabilities, requirements);
                    }
                    zipInputStream.closeEntry();
                }
            }
            finally {
                try {
                    if (zipInputStream != null) {
                        zipInputStream.close();
                    }
                }
                catch (IOException ioexception) {
                    this.logger.debug(": Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTgzArchive(List<String> capabilities, List<String> requirements) throws IOException {
            TarArchiveInputStream tarGzInputStream = null;
            try {
                TarArchiveEntry entry;
                tarGzInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(this.inputStream));
                while ((entry = tarGzInputStream.getNextTarEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    this.processArchiveEntry((InputStream)tarGzInputStream, name, capabilities, requirements);
                }
            }
            finally {
                try {
                    if (tarGzInputStream != null) {
                        tarGzInputStream.close();
                    }
                }
                catch (IOException ioexception) {
                    this.logger.debug(": Tried to close JarInputStream, but it was already closed.", (Throwable)ioexception);
                }
            }
        }

        private void processArchiveEntry(InputStream inputStream, String name, List<String> capabilities, List<String> requirements) throws IOException {
            int read;
            File temporarySourceFile = new File(this.absoluteTempResourcesPath.toAbsolutePath() + File.separator + FilenameUtils.separatorsToSystem((String)name));
            temporarySourceFile.getParentFile().mkdirs();
            BufferedOutputStream temporarySourceFileOutputStream = new BufferedOutputStream(new FileOutputStream(temporarySourceFile));
            byte[] bytes = new byte[4096];
            while ((read = inputStream.read(bytes)) != -1) {
                temporarySourceFileOutputStream.write(bytes, 0, read);
            }
            temporarySourceFileOutputStream.close();
            if (FilenameUtils.getName((String)name).equals(WebPackageURLConnection.PACKAGE_JSON)) {
                this.processPackageJson(temporarySourceFile, name, capabilities, requirements);
            }
        }

        private void processPackageJson(File temporarySourceFile, String name, List<String> capabilities, List<String> requirements) throws FileNotFoundException {
            Map<String, Object> packageJson = this.parsePackageJson(new FileInputStream(temporarySourceFile));
            String moduleName = (String)packageJson.get("name");
            String moduleVersion = VersionParser.parseVersion((String)packageJson.get("version")).toString();
            String root = name.replace(WebPackageURLConnection.PACKAGE_JSON, "");
            if (root.endsWith("/")) {
                root = root.substring(0, root.length() - 1);
            }
            capabilities.add("org.pentaho.webpackage;name=\"" + moduleName + "\";version:Version=\"" + moduleVersion + "\";root=\"/" + this.resourcesFolderName + "/" + root + "\"");
        }

        public Map<String, Object> parsePackageJson(InputStream inputStream) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                return (Map)new JSONParser().parse((Reader)bufferedReader);
            }
            catch (Exception e) {
                throw new RuntimeException("Error opening package.json", e);
            }
        }

        private void init() throws IOException {
            this.absoluteTempPath = Files.createTempDirectory("PentahoWebPackageDeployer", new FileAttribute[0]);
            this.resourcesFolderName = "pwp-" + UUID.randomUUID().toString();
            this.absoluteTempResourcesPath = Files.createDirectory(this.absoluteTempPath.resolve(this.resourcesFolderName), new FileAttribute[0]);
        }

        private Manifest createManifest() {
            String possibleVersion;
            String name = FilenameUtils.getBaseName((String)this.url.getPath());
            Version version = VersionParser.DEFAULT;
            int i = name.lastIndexOf(45);
            if (i != -1 && Character.isDigit((possibleVersion = name.substring(i + 1)).charAt(0)) && !(version = VersionParser.parseVersion(possibleVersion)).equals((Object)VersionParser.DEFAULT)) {
                name = name.substring(0, i);
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(new Attributes.Name("Bundle-ManifestVersion"), "2");
            manifest.getMainAttributes().put(new Attributes.Name("Bundle-SymbolicName"), "pentaho-webpackage-" + name);
            manifest.getMainAttributes().put(new Attributes.Name("Bundle-Version"), version.toString());
            return manifest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyFileToZip(JarOutputStream zip, String entry, File file) throws IOException {
            byte[] readBuffer = new byte[4096];
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(entry);
                zip.putNextEntry(zipEntry);
                int bytesIn = inputStream.read(readBuffer);
                while (bytesIn != -1) {
                    zip.write(readBuffer, 0, bytesIn);
                    bytesIn = inputStream.read(readBuffer);
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        static class VersionParser {
            private static Logger logger = LoggerFactory.getLogger(VersionParser.class);
            private static Version DEFAULT = new Version(0, 0, 0);
            private static Pattern VERSION_PAT = Pattern.compile("([0-9]+)?(?:\\.([0-9]*)(?:\\.([0-9]*))?)?[\\.-]?(.*)");
            private static Pattern CLASSIFIER_PAT = Pattern.compile("[a-zA-Z0-9_\\-]+");

            VersionParser() {
            }

            static Version parseVersion(String incomingVersion) {
                if (incomingVersion == null || incomingVersion.isEmpty()) {
                    return DEFAULT;
                }
                Matcher m = VERSION_PAT.matcher(incomingVersion);
                if (!m.matches()) {
                    return DEFAULT;
                }
                String s_major = m.group(1);
                String s_minor = m.group(2);
                String s_patch = m.group(3);
                String classifier = m.group(4);
                Integer major = 0;
                Integer minor = 0;
                Integer patch = 0;
                if (s_major != null && !s_major.isEmpty()) {
                    try {
                        major = Integer.parseInt(s_major);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Major version part not an integer: " + s_major);
                    }
                }
                if (s_minor != null && !s_minor.isEmpty()) {
                    try {
                        minor = Integer.parseInt(s_minor);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Minor version part not an integer: " + s_minor);
                    }
                }
                if (s_patch != null && !s_patch.isEmpty()) {
                    try {
                        patch = Integer.parseInt(s_patch);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Patch version part not an integer: " + s_patch);
                    }
                }
                if (classifier != null && !CLASSIFIER_PAT.matcher(classifier = classifier.replaceAll("\\.", "_")).matches()) {
                    logger.warn("Provided Classifier not valid for OSGI, ignoring");
                    classifier = null;
                }
                if (classifier != null) {
                    return new Version(major.intValue(), minor.intValue(), patch.intValue(), classifier);
                }
                return new Version(major.intValue(), minor.intValue(), patch.intValue());
            }
        }
    }
}

