/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.parameters;

import de.simplicit.vjdbc.parameters.PreparedStatementParameter;
import de.simplicit.vjdbc.serial.StreamSerializer;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CharStreamParameter
implements PreparedStatementParameter {
    static final long serialVersionUID = -3934051486806729706L;
    private char[] _value;

    public CharStreamParameter() {
    }

    public CharStreamParameter(Reader x) throws SQLException {
        try {
            this._value = StreamSerializer.toCharArray(x);
        }
        catch (IOException e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    public CharStreamParameter(Reader x, long length) throws SQLException {
        try {
            this._value = StreamSerializer.toCharArray(x, length);
        }
        catch (IOException e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    public char[] getValue() {
        return this._value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._value = (char[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._value);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index) throws SQLException {
        pstmt.setCharacterStream(index, (Reader)new CharArrayReader(this._value), this._value.length);
    }

    public String toString() {
        return "CharStream: " + this._value.length + " chars";
    }
}

