/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;
import org.pentaho.requirejs.IPlatformPluginRequireJsConfigurations;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;
import org.pentaho.requirejs.impl.utils.JsonMerger;
import org.pentaho.requirejs.impl.utils.RequireJsDependencyResolver;

public class RebuildCacheCallable
implements Callable<String> {
    private final List<IRequireJsPackageConfigurationPlugin> plugins;
    private final String baseUrl;
    private final Collection<IRequireJsPackageConfiguration> packageConfigurations;
    private final List<IPlatformPluginRequireJsConfigurations> requireJsConfigurations;

    public RebuildCacheCallable(String baseUrl, Collection<IRequireJsPackageConfiguration> packageConfigurations, Collection<IPlatformPluginRequireJsConfigurations> requireJsConfigurations, List<IRequireJsPackageConfigurationPlugin> plugins) {
        this.baseUrl = baseUrl;
        this.packageConfigurations = packageConfigurations;
        this.requireJsConfigurations = new ArrayList<IPlatformPluginRequireJsConfigurations>(requireJsConfigurations);
        this.plugins = plugins;
    }

    @Override
    public String call() {
        RequireJsDependencyResolver dependencyResolver = new RequireJsDependencyResolver(this.packageConfigurations);
        BiFunction<String, String, IRequireJsPackageConfiguration> getResolvedVersion = dependencyResolver::getResolvedVersion;
        Map<String, Object> requireJsConfig = this.createEmptyRequireConfig();
        JsonMerger merger = new JsonMerger();
        for (IRequireJsPackageConfiguration packageConfiguration : this.packageConfigurations) {
            packageConfiguration.processDependencies(getResolvedVersion);
            requireJsConfig = merger.merge(requireJsConfig, packageConfiguration.getRequireConfig(this.plugins));
        }
        RebuildCacheCallable.makePathsAbsolute(requireJsConfig, this.baseUrl);
        StringBuilder sb = new StringBuilder(JSONObject.toJSONString(requireJsConfig));
        sb.append(";\n");
        this.packageConfigurations.forEach(requireJsPackage -> {
            URL preconfig;
            if (requireJsPackage.hasScript("preconfig") && (preconfig = requireJsPackage.getScriptResource("preconfig")) != null) {
                try {
                    HashMap<String, String> packageInfo = new HashMap<String, String>();
                    packageInfo.put("name", requireJsPackage.getName());
                    packageInfo.put("version", requireJsPackage.getVersion());
                    packageInfo.put("webRootPath", this.baseUrl + requireJsPackage.getWebRootPath());
                    sb.append("\n\n(function(requireCfg, packageInfo, getVersionedModuleId) {\n");
                    sb.append("  try {\n");
                    this.appendFromResource(sb, preconfig);
                    sb.append("  } catch(e) {\n");
                    sb.append("    console.error(\"Failed executing " + requireJsPackage.getName() + "@" + requireJsPackage.getVersion() + " preconfig script\");\n");
                    sb.append("    console.error(e.stack);\n");
                    sb.append("  }\n");
                    sb.append("\n})(requireCfg, " + JSONObject.toJSONString(packageInfo) + ", getVersionedModuleId.bind(null, " + JSONObject.toJSONString((Map)requireJsPackage.getBaseModuleIdsMapping()) + "));\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        for (IPlatformPluginRequireJsConfigurations requireJsConfiguration : this.requireJsConfigurations) {
            try {
                String bundleName = requireJsConfiguration.getName();
                sb.append("\n\n/* Following configurations are from bundle ");
                sb.append(bundleName);
                sb.append(" */\n");
                for (URL configURL : requireJsConfiguration.getRequireConfigurationsURLs()) {
                    this.appendFromResource(sb, configURL);
                }
                sb.append("/* End of bundle ");
                sb.append(bundleName);
                sb.append(" */\n");
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    private Map<String, Object> createEmptyRequireConfig() {
        HashMap<String, Object> emptyConfig = new HashMap<String, Object>();
        emptyConfig.put("paths", new HashMap());
        emptyConfig.put("packages", new ArrayList());
        emptyConfig.put("bundles", new HashMap());
        HashMap map = new HashMap();
        map.put("*", new HashMap());
        emptyConfig.put("map", map);
        emptyConfig.put("config", new HashMap());
        emptyConfig.put("shim", new HashMap());
        return emptyConfig;
    }

    private static void makePathsAbsolute(Map<String, Object> result, String baseUrl) {
        HashMap paths = (HashMap)result.get("paths");
        paths.forEach((moduleId, location) -> {
            if (RebuildCacheCallable.checkNeedsBaseUrl(location)) {
                paths.put(moduleId, baseUrl + location);
            }
        });
        ArrayList packages = (ArrayList)result.get("packages");
        ArrayList convertedPackages = packages.stream().filter(Objects::nonNull).map(packageDefinition -> {
            String location;
            HashMap complexPackageDefinition;
            if (packageDefinition instanceof HashMap && (complexPackageDefinition = (HashMap)packageDefinition).containsKey("location") && RebuildCacheCallable.checkNeedsBaseUrl(location = (String)complexPackageDefinition.get("location"))) {
                complexPackageDefinition.put("location", baseUrl + location);
                return complexPackageDefinition;
            }
            return packageDefinition;
        }).collect(Collectors.toCollection(ArrayList::new));
        result.put("packages", convertedPackages);
    }

    private static boolean checkNeedsBaseUrl(String value) {
        return value.charAt(0) != '/' && !value.matches("/^[\\w\\+\\.\\-]+:/");
    }

    private void appendFromResource(StringBuilder sb, URL configURL) throws IOException {
        URLConnection urlConnection = configURL.openConnection();
        try (InputStream inputStream = urlConnection.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String input;
            while ((input = bufferedReader.readLine()) != null) {
                sb.append(input);
                sb.append("\n");
            }
        }
    }
}

