/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;
import org.pentaho.requirejs.impl.types.MetaInfRequireJson;

public class NomAmdPackageShim
implements IRequireJsPackageConfigurationPlugin {
    public void apply(IRequireJsPackageConfiguration requireJsPackageConfig, Function<String, IRequireJsPackageConfiguration> dependencyResolver, Function<String, String> resolveModuleId, Map<String, ?> requireConfig) {
        MetaInfRequireJson metaInfRequireJson;
        if (requireJsPackageConfig.getRequireJsPackage() instanceof MetaInfRequireJson && !(metaInfRequireJson = (MetaInfRequireJson)requireJsPackageConfig.getRequireJsPackage()).isAmdPackage()) {
            Map<String, String> modules;
            LinkedHashSet packageShimDependencies = new LinkedHashSet();
            Map dependencies = requireJsPackageConfig.getDependencies();
            for (String dependencyPackageName : dependencies.keySet()) {
                MetaInfRequireJson depMetaInfRequireJson;
                IRequireJsPackageConfiguration dependencyResolvedVersion = dependencyResolver.apply(dependencyPackageName);
                if (dependencyResolvedVersion == null || !(dependencyResolvedVersion.getRequireJsPackage() instanceof MetaInfRequireJson) || (depMetaInfRequireJson = (MetaInfRequireJson)dependencyResolvedVersion.getRequireJsPackage()).isAmdPackage()) continue;
                packageShimDependencies.addAll(dependencyResolvedVersion.getBaseModuleIdsMapping().values());
            }
            Map shim = (Map)requireConfig.get("shim");
            HashMap<String, Object> packageShim = new HashMap<String, Object>();
            if (!packageShimDependencies.isEmpty()) {
                packageShim.put("deps", Collections.unmodifiableList(new ArrayList(packageShimDependencies)));
            }
            if (metaInfRequireJson.getExports() != null && !metaInfRequireJson.getExports().isEmpty()) {
                packageShim.put("exports", metaInfRequireJson.getExports());
            }
            if (!packageShim.isEmpty() && (modules = metaInfRequireJson.getModules()) != null) {
                modules.forEach((moduleId, path) -> {
                    String versionedModuleId = (String)resolveModuleId.apply((String)moduleId);
                    shim.put(versionedModuleId, packageShim);
                    String moduleMainFile = metaInfRequireJson.getModuleMainFile((String)moduleId);
                    if (moduleMainFile != null) {
                        shim.put(versionedModuleId + "/" + moduleMainFile, packageShim);
                    }
                });
            }
        }
    }
}

