/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.listeners;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.pentaho.requirejs.IRequireJsPackage;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.impl.RequireJsConfigManager;
import org.pentaho.requirejs.impl.RequireJsPackageConfigurationImpl;

public class RequireJsPackageServiceTracker
implements ServiceTrackerCustomizer<IRequireJsPackage, IRequireJsPackageConfiguration> {
    private BundleContext bundleContext;
    private RequireJsConfigManager requireJsConfigManager;
    private ServiceTracker<IRequireJsPackage, IRequireJsPackageConfiguration> serviceTracker;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setRequireJsConfigManager(RequireJsConfigManager requireJsConfigManager) {
        this.requireJsConfigManager = requireJsConfigManager;
    }

    public void init() {
        this.serviceTracker = new ServiceTracker(this.bundleContext, IRequireJsPackage.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open(true);
    }

    public void destroy() {
        this.serviceTracker.close();
        this.serviceTracker = null;
    }

    public List<IRequireJsPackageConfiguration> getPackages() {
        return new ArrayList<IRequireJsPackageConfiguration>(this.serviceTracker.getTracked().values());
    }

    public IRequireJsPackageConfiguration addingService(ServiceReference<IRequireJsPackage> reference) {
        Bundle bundle = reference.getBundle();
        if (bundle != null) {
            this.requireJsConfigManager.invalidateCachedConfigurations();
            return new RequireJsPackageConfigurationImpl((IRequireJsPackage)this.bundleContext.getService(reference));
        }
        return null;
    }

    public void modifiedService(ServiceReference<IRequireJsPackage> reference, IRequireJsPackageConfiguration config) {
        config.processRequireJsPackage();
        this.requireJsConfigManager.invalidateCachedConfigurations();
    }

    public void removedService(ServiceReference<IRequireJsPackage> reference, IRequireJsPackageConfiguration config) {
        this.bundleContext.ungetService(reference);
        this.requireJsConfigManager.invalidateCachedConfigurations();
    }
}

