/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONObject;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;
import org.pentaho.requirejs.impl.listeners.RequireJsBundleListener;
import org.pentaho.requirejs.impl.listeners.RequireJsPackageServiceTracker;
import org.pentaho.requirejs.impl.servlet.RebuildCacheCallable;

public class RequireJsConfigManager {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        thread.setName("RequireJSConfigManager pool");
        return thread;
    });
    private RequireJsPackageServiceTracker packageConfigurationsTracker;
    private RequireJsBundleListener externalResourcesScriptsTracker;
    private List<IRequireJsPackageConfigurationPlugin> plugins;
    private volatile ConcurrentHashMap<String, Future<String>> cachedConfigurations = new ConcurrentHashMap(3);
    private volatile ConcurrentHashMap<String, String> cachedContextMapping = new ConcurrentHashMap();

    public void setPackageConfigurationsTracker(RequireJsPackageServiceTracker packageConfigurationsTracker) {
        this.packageConfigurationsTracker = packageConfigurationsTracker;
    }

    public void setExternalResourcesScriptsTracker(RequireJsBundleListener externalResourcesScriptsTracker) {
        this.externalResourcesScriptsTracker = externalResourcesScriptsTracker;
    }

    public void setPlugins(List<IRequireJsPackageConfigurationPlugin> plugins) {
        this.plugins = plugins;
    }

    public void destroy() {
        this.invalidateCachedConfigurations();
    }

    public String getRequireJsConfig(String baseUrl) {
        baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        String result = null;
        int tries = 3;
        Throwable lastException = null;
        while (tries-- > 0 && result == null) {
            Future<String> cache = this.getCachedConfiguration(baseUrl);
            try {
                result = cache.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                lastException = e;
                this.invalidateCachedConfigurations();
            }
        }
        if (result == null) {
            result = "{}; // Error computing RequireJS Config: ";
            result = lastException != null && lastException.getCause() != null ? result + lastException.getCause().getMessage() : result + "unknown error";
        }
        return result;
    }

    public String getContextMapping(String baseUrl, String referer) {
        return this.getCachedContextMapping(baseUrl, referer);
    }

    public void invalidateCachedConfigurations() {
        this.cachedConfigurations.forEach((s, stringFuture) -> stringFuture.cancel(true));
        this.cachedConfigurations.clear();
        this.cachedContextMapping.clear();
    }

    Future<String> getCachedConfiguration(String baseUrl) {
        return this.cachedConfigurations.computeIfAbsent(baseUrl, key -> executorService.schedule(this.createRebuildCacheCallable((String)key), 250L, TimeUnit.MILLISECONDS));
    }

    private String getCachedContextMapping(String baseUrl, String referer) {
        if (referer != null) {
            return this.cachedContextMapping.computeIfAbsent(referer, k -> {
                List<IRequireJsPackageConfiguration> requireJsPackageConfigurations = this.packageConfigurationsTracker.getPackages();
                for (IRequireJsPackageConfiguration requireJsPackage : requireJsPackageConfigurations) {
                    String webRootPath = requireJsPackage.getWebRootPath();
                    if (webRootPath == null || webRootPath.isEmpty() || !referer.toLowerCase().contains((baseUrl + webRootPath).toLowerCase())) continue;
                    HashMap contextConfig = new HashMap();
                    HashMap topMap = new HashMap();
                    HashMap map = new HashMap();
                    requireJsPackage.getModuleIdsMapping().forEach(map::put);
                    topMap.put("*", map);
                    contextConfig.put("map", topMap);
                    return JSONObject.toJSONString(contextConfig);
                }
                return null;
            });
        }
        return null;
    }

    Callable<String> createRebuildCacheCallable(String baseUrl) {
        return new RebuildCacheCallable(baseUrl, this.packageConfigurationsTracker.getPackages(), this.externalResourcesScriptsTracker.getScripts(), this.plugins);
    }
}

