/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util.ftpfile;

import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FileParser;

public class EPLFFileParser
implements FileParser {
    private static final Logger log = Logger.getLogger(EPLFFileParser.class);
    public static final char EPLF_START_CHAR = '+';

    public FTPFile parse(String serverString, String parentDirectory) throws ParseException {
        if (serverString.charAt(0) != '+') {
            throw new ParseException("Not an EPLF LIST response (no '+' on line start)", 0);
        }
        serverString = serverString.substring(1);
        StringTokenizer st = new StringTokenizer(serverString, ",");
        Date date = null;
        String fileName = "";
        String mode = "";
        long size = -1L;
        boolean directory = false;
        block7: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (token.charAt(0)) {
                case 'r': {
                    mode = mode + "r--r--r--";
                    continue block7;
                }
                case '/': {
                    directory = true;
                    mode = "d" + mode;
                    continue block7;
                }
                case 's': {
                    size = Long.parseLong(token.substring(1));
                    continue block7;
                }
                case 'm': {
                    date = new Date(Long.parseLong(token.substring(1)) * 1000L);
                    continue block7;
                }
                case '\t': {
                    fileName = token.trim();
                    continue block7;
                }
            }
            log.debug((Object)("skip unnessacry token: " + token));
        }
        if (mode.length() == 9) {
            mode = "-" + mode;
        }
        FTPFile file = new FTPFile(-1, parentDirectory, fileName, serverString);
        file.setDate(date);
        file.setMode(mode);
        file.setDirectory(directory);
        file.setSize(size);
        return file;
    }
}

