/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.Attachment;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentColumnInfo
extends ComplexColumnInfo<Attachment> {
    private static final String FILE_NAME_COL_NAME = "FileName";
    private static final String FILE_TYPE_COL_NAME = "FileType";
    private final Column _fileUrlCol;
    private final Column _fileNameCol;
    private final Column _fileTypeCol;
    private final Column _fileDataCol;
    private final Column _fileTimeStampCol;
    private final Column _fileFlagsCol;

    public AttachmentColumnInfo(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
        Column fileUrlCol = null;
        Column fileNameCol = null;
        Column fileTypeCol = null;
        Column fileDataCol = null;
        Column fileTimeStampCol = null;
        Column fileFlagsCol = null;
        for (Column col : this.getTypeColumns()) {
            switch (col.getType()) {
                case TEXT: {
                    if (FILE_NAME_COL_NAME.equalsIgnoreCase(col.getName())) {
                        fileNameCol = col;
                        break;
                    }
                    if (FILE_TYPE_COL_NAME.equalsIgnoreCase(col.getName())) {
                        fileTypeCol = col;
                        break;
                    }
                    if (fileNameCol == null) {
                        fileNameCol = col;
                        break;
                    }
                    if (fileTypeCol != null) break;
                    fileTypeCol = col;
                    break;
                }
                case LONG: {
                    fileFlagsCol = col;
                    break;
                }
                case SHORT_DATE_TIME: {
                    fileTimeStampCol = col;
                    break;
                }
                case OLE: {
                    fileDataCol = col;
                    break;
                }
                case MEMO: {
                    fileUrlCol = col;
                    break;
                }
            }
        }
        this._fileUrlCol = fileUrlCol;
        this._fileNameCol = fileNameCol;
        this._fileTypeCol = fileTypeCol;
        this._fileDataCol = fileDataCol;
        this._fileTimeStampCol = fileTimeStampCol;
        this._fileFlagsCol = fileFlagsCol;
    }

    public Column getFileUrlColumn() {
        return this._fileUrlCol;
    }

    public Column getFileNameColumn() {
        return this._fileNameCol;
    }

    public Column getFileTypeColumn() {
        return this._fileTypeCol;
    }

    public Column getFileDataColumn() {
        return this._fileDataCol;
    }

    public Column getFileTimeStampColumn() {
        return this._fileTimeStampCol;
    }

    public Column getFileFlagsColumn() {
        return this._fileFlagsCol;
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.ATTACHMENT;
    }

    @Override
    protected AttachmentImpl toValue(ComplexValueForeignKey complexValueFk, Map<String, Object> rawValue) {
        int id = (Integer)this.getPrimaryKeyColumn().getRowValue(rawValue);
        String url = (String)this.getFileUrlColumn().getRowValue(rawValue);
        String name = (String)this.getFileNameColumn().getRowValue(rawValue);
        String type = (String)this.getFileTypeColumn().getRowValue(rawValue);
        Integer flags = (Integer)this.getFileFlagsColumn().getRowValue(rawValue);
        Date ts = (Date)this.getFileTimeStampColumn().getRowValue(rawValue);
        byte[] data = (byte[])this.getFileDataColumn().getRowValue(rawValue);
        return new AttachmentImpl(id, complexValueFk, url, name, type, data, ts, flags);
    }

    @Override
    protected Object[] asRow(Object[] row, Attachment attachment) {
        super.asRow(row, attachment);
        this.getFileUrlColumn().setRowValue(row, (Object)attachment.getFileUrl());
        this.getFileNameColumn().setRowValue(row, (Object)attachment.getFileName());
        this.getFileTypeColumn().setRowValue(row, (Object)attachment.getFileType());
        this.getFileFlagsColumn().setRowValue(row, (Object)attachment.getFileFlags());
        this.getFileTimeStampColumn().setRowValue(row, (Object)attachment.getFileTimeStamp());
        this.getFileDataColumn().setRowValue(row, (Object)attachment.getFileData());
        return row;
    }

    public static Attachment newAttachment(byte[] data) {
        return AttachmentColumnInfo.newAttachment(INVALID_COMPLEX_VALUE_ID, data);
    }

    public static Attachment newAttachment(ComplexValueForeignKey complexValueFk, byte[] data) {
        return AttachmentColumnInfo.newAttachment(complexValueFk, null, null, null, data, null, null);
    }

    public static Attachment newAttachment(String url, String name, String type, byte[] data, Date timeStamp, Integer flags) {
        return AttachmentColumnInfo.newAttachment(INVALID_COMPLEX_VALUE_ID, url, name, type, data, timeStamp, flags);
    }

    public static Attachment newAttachment(ComplexValueForeignKey complexValueFk, String url, String name, String type, byte[] data, Date timeStamp, Integer flags) {
        return new AttachmentImpl(-1, complexValueFk, url, name, type, data, timeStamp, flags);
    }

    public static boolean isAttachmentColumn(Table typeObjTable) {
        List<Column> typeCols = typeObjTable.getColumns();
        if (typeCols.size() < 6) {
            return false;
        }
        int numMemo = 0;
        int numText = 0;
        int numDate = 0;
        int numOle = 0;
        int numLong = 0;
        for (Column col : typeCols) {
            switch (col.getType()) {
                case TEXT: {
                    ++numText;
                    break;
                }
                case LONG: {
                    ++numLong;
                    break;
                }
                case SHORT_DATE_TIME: {
                    ++numDate;
                    break;
                }
                case OLE: {
                    ++numOle;
                    break;
                }
                case MEMO: {
                    ++numMemo;
                    break;
                }
            }
        }
        return numMemo >= 1 && numText >= 2 && numOle >= 1 && numDate >= 1 && numLong >= 1;
    }

    private static class AttachmentImpl
    extends ComplexColumnInfo.ComplexValueImpl
    implements Attachment {
        private String _url;
        private String _name;
        private String _type;
        private byte[] _data;
        private Date _timeStamp;
        private Integer _flags;

        private AttachmentImpl(int id, ComplexValueForeignKey complexValueFk, String url, String name, String type, byte[] data, Date timeStamp, Integer flags) {
            super(id, complexValueFk);
            this._url = url;
            this._name = name;
            this._type = type;
            this._data = data;
            this._timeStamp = timeStamp;
            this._flags = flags;
        }

        public byte[] getFileData() {
            return this._data;
        }

        public void setFileData(byte[] data) {
            this._data = data;
        }

        public String getFileName() {
            return this._name;
        }

        public void setFileName(String fileName) {
            this._name = fileName;
        }

        public String getFileUrl() {
            return this._url;
        }

        public void setFileUrl(String fileUrl) {
            this._url = fileUrl;
        }

        public String getFileType() {
            return this._type;
        }

        public void setFileType(String fileType) {
            this._type = fileType;
        }

        public Date getFileTimeStamp() {
            return this._timeStamp;
        }

        public void setFileTimeStamp(Date fileTimeStamp) {
            this._timeStamp = fileTimeStamp;
        }

        public Integer getFileFlags() {
            return this._flags;
        }

        public void setFileFlags(Integer fileFlags) {
            this._flags = fileFlags;
        }

        public void update() throws IOException {
            this.getComplexValueForeignKey().updateAttachment(this);
        }

        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteAttachment(this);
        }

        public String toString() {
            return "Attachment(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getFileUrl() + ", " + this.getFileName() + ", " + this.getFileType() + ", " + this.getFileTimeStamp() + ", " + this.getFileFlags() + ", " + ByteUtil.toHexString(this.getFileData());
        }
    }
}

