/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.remote;

import org.pentaho.di.engine.api.remote.Message;

public class StopMessage
implements Message {
    private static final long serialVersionUID = 8842623444691045346L;
    private String reasonPhrase;
    private String requestUUID;
    private Status result;
    private final boolean safeStop;

    public StopMessage(String reasonPhrase) {
        this(null, reasonPhrase, Status.SUCCESS, false);
    }

    public StopMessage(String requestUUID, String reasonPhrase) {
        this(requestUUID, reasonPhrase, Status.SUCCESS, false);
    }

    public StopMessage(String reasonPhrase, Status result) {
        this(null, reasonPhrase, result, false);
    }

    public StopMessage(String requestUUID, String reasonPhrase, Status result) {
        this(requestUUID, reasonPhrase, result, false);
    }

    private StopMessage(String requestUUID, String reasonPhrase, Status result, boolean safeStop) {
        this.requestUUID = requestUUID;
        this.reasonPhrase = reasonPhrase;
        this.result = result;
        this.safeStop = safeStop;
    }

    public String getRequestUUID() {
        return this.requestUUID;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean operationSuccessful() {
        return this.result == Status.SUCCESS;
    }

    public boolean operationFailed() {
        return this.result == Status.FAILED;
    }

    public boolean sessionWasKilled() {
        return this.result == Status.SESSION_KILLED;
    }

    public boolean isSafeStop() {
        return this.safeStop;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String reasonPhrase;
        private String requestUUID;
        private Status result;
        private boolean safeStop = false;

        public Builder reasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        public Builder requestUUID(String requestUUID) {
            this.requestUUID = requestUUID;
            return this;
        }

        public Builder result(Status result) {
            this.result = result;
            return this;
        }

        public Builder safeStop(boolean safeStop) {
            this.safeStop = safeStop;
            return this;
        }

        public StopMessage build() {
            return new StopMessage(this.requestUUID, this.reasonPhrase, this.result, this.safeStop);
        }
    }

    public static enum Status {
        SESSION_KILLED,
        SUCCESS,
        FAILED;

    }
}

