/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64OutputStream;

public class EncodeUtil {
    private static final int ZIP_BUFFER_SIZE = 8192;

    public static byte[] decodeBase64Zipped(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes64 = Base64.decodeBase64((byte[])string.getBytes());
        ByteArrayInputStream zip = new ByteArrayInputStream(bytes64);
        try (GZIPInputStream unzip = new GZIPInputStream((InputStream)zip, 8192);
             BufferedInputStream in = new BufferedInputStream(unzip, 8192);){
            byte[] buff = new byte[8192];
            int length = 0;
            while ((length = in.read(buff)) > 0) {
                baos.write(buff, 0, length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error trying to decode object.", e);
        }
        return baos.toByteArray();
    }

    public static String encodeBase64Zipped(byte[] src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)baos);
             GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)base64OutputStream);){
            gzos.write(src);
        }
        return baos.toString();
    }
}

