/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metaverse.api.model.DbcResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class OCIResourceInfo
extends DbcResourceInfo
implements IExternalResourceInfo {
    public static final String OCI = "OCI";
    public static final String JSON_PROPERTY_DATA_TABLESPACE = "data_tablespace";
    public static final String JSON_PROPERTY_INDEX_TABLESPACE = "index_tablespace";
    private String dataTablespace;
    private String indexTablespace;

    @Override
    public String getType() {
        return OCI;
    }

    public OCIResourceInfo() {
    }

    public OCIResourceInfo(DatabaseMeta databaseMeta) {
        super(databaseMeta);
        if (!OCI.equals(databaseMeta.getAccessTypeDesc())) {
            throw new IllegalArgumentException("DatabaseMeta is not OCI, it is " + databaseMeta.getAccessTypeDesc());
        }
        this.setUsername(databaseMeta.environmentSubstitute(databaseMeta.getUsername()));
        this.setPassword(databaseMeta.environmentSubstitute(databaseMeta.getPassword()));
        this.setDatabaseName(databaseMeta.environmentSubstitute(databaseMeta.getDatabaseName()));
        this.setDataTablespace(databaseMeta.environmentSubstitute(databaseMeta.getDataTablespace()));
        this.setIndexTablespace(databaseMeta.environmentSubstitute(databaseMeta.getIndexTablespace()));
    }

    public OCIResourceInfo(String databaseName, String username, String password) {
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
    }

    @JsonProperty(value="data_tablespace")
    public String getDataTablespace() {
        return this.dataTablespace;
    }

    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    @JsonProperty(value="index_tablespace")
    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCIResourceInfo that = (OCIResourceInfo)o;
        return Objects.equals(this.dataTablespace, that.dataTablespace) && Objects.equals(this.indexTablespace, that.indexTablespace);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataTablespace, this.indexTablespace);
    }
}

