/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.annotations;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotationDrivenStepMetaAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.JobEntryAnalyzer;

public class AnnotationDrivenJobAnalyzer
extends JobEntryAnalyzer<JobEntryInterface> {
    private transient JobEntryInterface jobEntry;

    public AnnotationDrivenJobAnalyzer(JobEntryInterface jobEntry) {
        this.jobEntry = jobEntry;
    }

    @Override
    protected void customAnalyze(JobEntryInterface entry, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        List baseStepMetas = Arrays.stream(entry.getClass().getMethods()).filter(m -> m.isAnnotationPresent(Metaverse.InternalStepMeta.class)).map(method -> this.getBaseStepMeta(entry, (Method)method)).collect(Collectors.toList());
        for (BaseStepMeta baseStepMeta : baseStepMetas) {
            this.analyzeInternalStepMeta(rootNode, baseStepMeta);
        }
    }

    private BaseStepMeta getBaseStepMeta(JobEntryInterface entry, Method method) {
        try {
            return (BaseStepMeta)method.invoke((Object)entry, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("InternalStepMeta annotation only allowed on BaseStepMeta methods");
        }
    }

    private void analyzeInternalStepMeta(IMetaverseNode rootNode, BaseStepMeta baseStepMeta) throws MetaverseAnalyzerException {
        AnnotationDrivenStepMetaAnalyzer stepAnalyzer = this.createStepAnalyzer(baseStepMeta);
        stepAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
        stepAnalyzer.setDocumentAnalyzer(this.documentAnalyzer);
        stepAnalyzer.setDocumentDescriptor(this.documentDescriptor);
        stepAnalyzer.setDocumentPath(this.documentPath);
        stepAnalyzer.setDescriptor(this.descriptor);
        stepAnalyzer.customAnalyze(baseStepMeta, rootNode);
    }

    @VisibleForTesting
    AnnotationDrivenStepMetaAnalyzer createStepAnalyzer(BaseStepMeta baseStepMeta) {
        return new AnnotationDrivenStepMetaAnalyzer(baseStepMeta, (VariableSpace)this.jobEntry.getParentJobMeta());
    }

    @Override
    public Set<Class<? extends JobEntryInterface>> getSupportedEntries() {
        return Collections.singleton(this.jobEntry.getClass());
    }
}

