/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.pentaho.metaverse.api.INamespace;

public class Namespace
implements INamespace {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private String namespace;

    public Namespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getNamespaceId() {
        return this.namespace;
    }

    @Override
    public INamespace getParentNamespace() {
        if (this.namespace != null) {
            try {
                JsonNode jsonObject = objectMapper.readTree(this.namespace);
                JsonNode namespaceNode = jsonObject.get("namespace");
                if (namespaceNode == null) {
                    return null;
                }
                String parent = namespaceNode.isTextual() ? namespaceNode.asText() : namespaceNode.toString();
                return new Namespace(parent);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public INamespace getSiblingNamespace(String name, String type) {
        if (this.namespace != null) {
            try {
                JsonNode jsonObject = objectMapper.readTree(this.namespace);
                if (jsonObject.isObject()) {
                    ObjectNode object = (ObjectNode)jsonObject;
                    object.put("name", name);
                    object.put("type", type);
                }
                return new Namespace(objectMapper.writeValueAsString((Object)jsonObject));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

