/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.utils;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.pentaho.hadoop.shim.common.utils.OverloadedIterator;

public class OverloadedServiceLoader<S>
implements Iterable<S> {
    private ServiceLoader<S> loader;
    private OverloadedLazyIterator<S> iterator;

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        OverloadedServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    public OverloadedServiceLoader(ServiceLoader<S> loader) {
        this.loader = loader;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPrivateField(String fieldName, Object obj) {
        Field f = null;
        try {
            f = obj.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            Object object = f.get(obj);
            return object;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPrivateField(String fieldName, Object obj, Object value) {
        Field f = null;
        try {
            f = obj.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(obj, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    public static <S> OverloadedServiceLoader<S> loadInstalled(Class<S> service) {
        return new OverloadedServiceLoader<S>(ServiceLoader.loadInstalled(service));
    }

    public static <S> OverloadedServiceLoader<S> load(Class<S> service) {
        return new OverloadedServiceLoader<S>(ServiceLoader.load(service));
    }

    public static <S> OverloadedServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new OverloadedServiceLoader<S>(ServiceLoader.load(service, loader));
    }

    public void reload() {
        this.loader.reload();
        this.iterator = new OverloadedLazyIterator((Iterator)this.getPrivateField("lookupIterator", this.loader));
    }

    @Override
    public Iterator<S> iterator() {
        return new OverloadedIterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ((LinkedHashMap)OverloadedServiceLoader.this.getPrivateField("providers", OverloadedServiceLoader.this.loader)).entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return OverloadedServiceLoader.this.iterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return OverloadedServiceLoader.this.iterator.next();
            }

            @Override
            public S next(Object ... args) {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return OverloadedServiceLoader.this.iterator.next(args);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "org.pentaho.hadoop.shim.common.utils.OverloadedServiceLoader[" + super.toString() + "]";
    }

    public class OverloadedLazyIterator<S>
    implements OverloadedIterator<S> {
        public Iterator<S> originalLookupIterator;

        public OverloadedLazyIterator(Iterator<S> originalLookupIterator) {
            this.originalLookupIterator = originalLookupIterator;
        }

        @Override
        public boolean hasNext() {
            return this.originalLookupIterator.hasNext();
        }

        @Override
        public S next() {
            return this.originalLookupIterator.next();
        }

        @Override
        public S next(Object ... args) {
            if (args == null) {
                return this.next();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = (String)OverloadedServiceLoader.this.getPrivateField("nextName", this.originalLookupIterator);
            OverloadedServiceLoader.this.setPrivateField("nextName", this.originalLookupIterator, null);
            Class<?> c = null;
            try {
                c = Class.forName(cn, false, (ClassLoader)OverloadedServiceLoader.this.getPrivateField("loader", this.originalLookupIterator));
            }
            catch (ClassNotFoundException x) {
                OverloadedServiceLoader.fail((Class)OverloadedServiceLoader.this.getPrivateField("service", this.originalLookupIterator), "Provider " + cn + " not found");
            }
            if (!((Class)OverloadedServiceLoader.this.getPrivateField("service", this.originalLookupIterator)).isAssignableFrom(c)) {
                OverloadedServiceLoader.fail((Class)OverloadedServiceLoader.this.getPrivateField("service", this.originalLookupIterator), "Provider " + cn + " not a subtype");
            }
            try {
                Object p = ((Class)OverloadedServiceLoader.this.getPrivateField("service", this.originalLookupIterator)).cast(c.getConstructor(this.getTypes(args)).newInstance(this.getArgs(args)));
                ((LinkedHashMap)OverloadedServiceLoader.this.getPrivateField("providers", OverloadedServiceLoader.this.loader)).put(cn, p);
                return (S)p;
            }
            catch (Throwable x) {
                OverloadedServiceLoader.fail((Class)OverloadedServiceLoader.this.getPrivateField("service", this.originalLookupIterator), "Provider " + cn + " could not be instantiated: " + x, x);
                throw new Error();
            }
        }

        private Class<?>[] getTypes(Object[] args) {
            int halfSize = args.length / 2;
            assert (args.length % 2 == 0);
            Class[] classes = new Class[halfSize];
            for (int i = 0; i < halfSize; ++i) {
                classes[i] = (Class)args[i * 2];
            }
            return classes;
        }

        private Object[] getArgs(Object[] args) {
            int halfSize = args.length / 2;
            assert (args.length % 2 == 0);
            Object[] values = new Object[halfSize];
            for (int i = 0; i < halfSize; ++i) {
                values[i] = args[i * 2 + 1];
            }
            return values;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

