/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.pentaho.hadoop.shim.common.invocationhandler.ResultSetMetaDataInvocationHandler;

public class ResultSetInvocationHandler
implements InvocationHandler {
    ResultSet rs;
    Statement st;

    public ResultSetInvocationHandler(ResultSet r) {
        this.rs = r;
    }

    public ResultSetInvocationHandler(ResultSet r, Statement s) {
        this.rs = r;
        this.st = s;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            if ("getString".equals(methodName) && args != null && args.length == 1 && args[0] instanceof String) {
                return this.getString((String)args[0]);
            }
            if ("getType".equals(methodName)) {
                return 1003;
            }
            Object o = method.invoke((Object)this.rs, args);
            if (o instanceof ResultSetMetaData) {
                return (ResultSetMetaData)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataInvocationHandler((ResultSetMetaData)o));
            }
            return o;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable cause = t.getCause();
                String methodName = method.getName();
                if (cause instanceof SQLException) {
                    if (cause.getMessage().equals("Method not supported")) {
                        if ("getStatement".equals(methodName)) {
                            return this.getStatement();
                        }
                        throw cause;
                    }
                    throw cause;
                }
                if (cause instanceof IllegalMonitorStateException && "close".equals(methodName)) {
                    return null;
                }
                throw cause;
            }
            throw t;
        }
    }

    private Statement getStatement() {
        return this.st;
    }

    public String getString(String columnName) throws SQLException {
        String columnVal = null;
        SQLException exception = null;
        try {
            columnVal = this.rs.getString(columnName);
        }
        catch (SQLException se) {
            exception = se;
        }
        if (columnVal != null) {
            return columnVal;
        }
        if (columnName != null && "TABLE_NAME".equals(columnName) && columnName != null && "TABLE_NAME".equals(columnName)) {
            try {
                columnVal = this.rs.getString(1);
            }
            catch (SQLException se) {
                throw exception == null ? se : exception;
            }
        }
        return columnVal;
    }
}

