/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.pentaho.hadoop.shim.common.DriverProxyInvocationChain;
import org.pentaho.hadoop.shim.common.invocationhandler.CaptureResultSetInvocationHandler;
import org.pentaho.hadoop.shim.common.invocationhandler.ConnectionInvocationHandler;
import org.pentaho.hadoop.shim.common.invocationhandler.ResultSetInvocationHandler;

public class DatabaseMetaDataInvocationHandler
implements InvocationHandler {
    DatabaseMetaData t;
    ConnectionInvocationHandler c;

    public DatabaseMetaDataInvocationHandler(DatabaseMetaData t, ConnectionInvocationHandler c) {
        this.t = t;
        this.c = c;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object o;
            String methodName = method.getName();
            if ("getTables".equals(methodName)) {
                if (DriverProxyInvocationChain.getHive1DbMetaDataClass() != null && DriverProxyInvocationChain.getHive1DbMetaDataClass().isAssignableFrom(this.t.getClass())) {
                    return this.getTables(this.t, DriverProxyInvocationChain.getHive1DbMetaDataClass(), DriverProxyInvocationChain.getHive1StatementClass(), DriverProxyInvocationChain.getHive1ClientClass(), (String)args[0], (String)args[1], (String)args[2], (String[])args[3], method, args);
                }
                if (DriverProxyInvocationChain.getHive2DbMetaDataClass() != null && DriverProxyInvocationChain.getHive2DbMetaDataClass().isAssignableFrom(this.t.getClass())) {
                    return this.getTables(this.t, DriverProxyInvocationChain.getHive2DbMetaDataClass(), DriverProxyInvocationChain.getHive2StatementClass(), DriverProxyInvocationChain.getHive2ClientClass(), (String)args[0], (String)args[1], (String)args[2], (String[])args[3], method, args);
                }
            } else {
                if ("getConnection".equals(methodName)) {
                    return this.c;
                }
                if ("getIdentifierQuoteString".equals(methodName)) {
                    return this.getIdentifierQuoteString();
                }
            }
            if ((o = method.invoke((Object)this.t, args)) instanceof ResultSet) {
                ResultSet r = (ResultSet)o;
                return (ResultSet)Proxy.newProxyInstance(r.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r));
            }
            return o;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable cause = t.getCause();
                throw cause;
            }
            throw t;
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "";
    }

    public ResultSet getTables(Object originalObject, Class<? extends DatabaseMetaData> dbMetadataClass, Class<? extends Statement> statementClass, Class<?> clientClass, String catalog, String schemaPattern, String tableNamePattern, String[] types, Method method, Object[] args) throws Exception {
        boolean tables = false;
        if (types == null) {
            tables = true;
        } else {
            for (String type : types) {
                if (!"TABLE".equals(type)) continue;
                tables = true;
            }
        }
        if (tables) {
            try {
                ResultSet r;
                ResultSet ret;
                Object o = method.invoke(originalObject, args);
                if (o instanceof ResultSet && (ret = (ResultSet)Proxy.newProxyInstance((r = (ResultSet)o).getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(r))).isBeforeFirst()) {
                    return ret;
                }
            }
            catch (Exception o) {
                // empty catch block
            }
            Statement showTables = null;
            if (this.c != null) {
                Statement st = this.c.createStatement(this.c.connection, null);
                showTables = (Statement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{Statement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
            } else {
                Constructor<? extends Statement> hiveStatementCtor = statementClass.getDeclaredConstructor(clientClass);
                try {
                    Field clientField = dbMetadataClass.getDeclaredField("client");
                    Object client = clientField.get(originalObject);
                    showTables = hiveStatementCtor.newInstance(clientClass.cast(client));
                }
                catch (Exception e) {
                    showTables = null;
                }
                if (showTables == null) {
                    try {
                        Method getClient = dbMetadataClass.getDeclaredMethod("getClient", new Class[0]);
                        Object client = getClient.invoke(originalObject, new Object[0]);
                        showTables = hiveStatementCtor.newInstance(clientClass.cast(client));
                    }
                    catch (Exception e) {
                        showTables = null;
                    }
                }
            }
            if (showTables != null) {
                ResultSet rs = schemaPattern != null ? showTables.executeQuery(String.format("show tables in %s", schemaPattern)) : showTables.executeQuery("show tables");
                if (rs != null) {
                    return (ResultSet)Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(rs));
                }
                return null;
            }
            throw new Exception("Cannot execute SHOW TABLES query");
        }
        Method getTables = dbMetadataClass.getDeclaredMethod("getTables", String.class, String.class, String.class, String[].class);
        ResultSet rs = (ResultSet)getTables.invoke(originalObject, catalog, schemaPattern, tableNamePattern, types);
        return rs;
    }
}

