/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.TypeDescription;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.api.format.org.pentaho.hadoop.shim.pvfs.api.PvfsHadoopBridgeFileSystemExtension;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;
import org.pentaho.hadoop.shim.common.format.orc.PentahoOrcRecordWriter;

public class PentahoOrcOutputFormat
extends HadoopFormatBase
implements IPentahoOrcOutputFormat {
    protected static final LogChannelInterface logger = LogChannel.GENERAL;
    protected String outputFilename;
    protected Configuration conf;
    protected IPentahoOrcOutputFormat.COMPRESSION compression = IPentahoOrcOutputFormat.COMPRESSION.NONE;
    protected int compressSize = 0;
    protected int stripeSize = 64;
    protected List<? extends IOrcOutputField> fields;

    public PentahoOrcOutputFormat() {
        this(null);
    }

    public PentahoOrcOutputFormat(NamedCluster namedCluster) {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.conf = new ConfigurationProxy();
        if (namedCluster != null) {
            BiConsumer<InputStream, String> consumer = (is, filename) -> this.conf.addResource(is, filename);
            ShimConfigsLoader.addConfigsAsResources(namedCluster, consumer);
        } else {
            this.conf.addResource("hive-site.xml");
        }
    }

    public IPentahoOutputFormat.IPentahoRecordWriter createRecordWriter() {
        logger.logDetailed("Initializing Orc Writer");
        if (this.fields == null) {
            throw new IllegalStateException("Invalid state.  The fields to write are null");
        }
        if (this.outputFilename == null) {
            throw new IllegalStateException("Invalid state.  The outputFileName is null");
        }
        OrcSchemaConverter converter = new OrcSchemaConverter();
        TypeDescription schema = converter.buildTypeDescription(this.fields);
        return new PentahoOrcRecordWriter(this.fields, schema, this.outputFilename, this.conf);
    }

    public void setFields(List<? extends IOrcOutputField> fields) {
        this.fields = fields;
    }

    public void setOutputFile(String file, boolean override) throws Exception {
        this.outputFilename = S3NCredentialUtils.scrubFilePathIfNecessary(file);
        S3NCredentialUtils util = new S3NCredentialUtils();
        util.applyS3CredentialsToHadoopConfigurationIfNecessary(file, this.conf);
        Path outputFile = new Path(this.outputFilename);
        FileSystem fs = FileSystem.get((URI)outputFile.toUri(), (Configuration)this.conf);
        if (fs.exists(outputFile)) {
            if (override) {
                fs.delete(outputFile, true);
            } else {
                throw new FileAlreadyExistsException(file);
            }
        }
    }

    public void setCompression(IPentahoOrcOutputFormat.COMPRESSION compression) {
        this.compression = compression;
        this.conf.set("orc.compress", compression.toString());
        if (compression == IPentahoOrcOutputFormat.COMPRESSION.NONE) {
            this.compressSize = 0;
            this.conf.unset("orc.compress.size");
        } else if (this.compressSize == 0) {
            this.compressSize = 256;
            this.conf.set("orc.compress.size", Integer.toString(256));
        }
    }

    public void setStripeSize(int megabytes) {
        if (this.stripeSize > 0) {
            this.stripeSize = megabytes;
            this.conf.set("orc.stripe.size", Integer.toString(0x100000 * this.stripeSize));
        }
    }

    public void setRowIndexStride(int numRows) {
        if (numRows > 0) {
            this.conf.set("orc.create.index", "true");
            this.conf.set("orc.row.index.stride", Integer.toString(0x100000 * numRows));
        } else if (numRows == 0) {
            this.conf.set("orc.create.index", "false");
            this.conf.unset("orc.row.index.stride");
        }
    }

    public void setCompressSize(int kilobytes) {
        if (kilobytes > 0) {
            this.compressSize = kilobytes;
            this.conf.set("orc.compress.size", Integer.toString(1024 * this.compressSize));
        } else if (kilobytes == 0) {
            this.compressSize = kilobytes;
            this.compression = IPentahoOrcOutputFormat.COMPRESSION.NONE;
            this.conf.unset("orc.compress.size");
            this.conf.set("orc.compress", this.compression.toString());
        }
    }

    public String generateAlias(String pvfsPath) {
        return this.inClassloader(() -> {
            FileSystem fs = FileSystem.get((URI)StringUtil.toUri((String)pvfsPath), (Configuration)this.conf);
            if (fs instanceof PvfsHadoopBridgeFileSystemExtension) {
                return ((PvfsHadoopBridgeFileSystemExtension)fs).generateAlias(pvfsPath);
            }
            return null;
        });
    }
}

