/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

public class S3CsvInputData
extends BaseStepData
implements StepDataInterface {
    public RowMetaInterface convertRowMeta;
    public RowMetaInterface outputRowMeta;
    private byte[] bb;
    public byte[] byteBuffer = new byte[0];
    public int startBuffer = 0;
    public int endBuffer = 0;
    public int bufferSize;
    public byte[] delimiter;
    public byte[] enclosure;
    public int preferredBufferSize;
    public String[] filenames;
    public int filenr;
    public int startFilenr;
    public byte[] binaryFilename;
    public long fileSize;
    public boolean isAddingRowNumber;
    public long rowNumber;
    public boolean stopReading;
    public int stepNumber;
    public int totalNumberOfSteps;
    public List<Long> fileSizes;
    public long totalFileSize;
    public long blockToRead;
    public long startPosition;
    public long endPosition;
    public long bytesToSkipInFirstFile;
    public long totalBytesRead = 0L;
    public boolean parallel;
    public AmazonS3 s3Client;
    public Bucket s3bucket;
    public int maxLineSize;
    public S3ObjectInputStream s3ObjectInputStream;

    public S3CsvInputData() {
        this.bb = new byte[50000];
    }

    public void resizeByteBuffer() {
        this.bufferSize = this.endBuffer - this.startBuffer;
        int newSize = this.bufferSize + this.preferredBufferSize;
        byte[] newByteBuffer = new byte[newSize];
        System.arraycopy(this.byteBuffer, this.startBuffer, newByteBuffer, 0, this.bufferSize);
        this.byteBuffer = newByteBuffer;
        this.startBuffer = 0;
        this.endBuffer = this.bufferSize;
    }

    public boolean readBufferFromFile() throws IOException {
        int n = this.s3ObjectInputStream.read(this.bb);
        if (n == -1) {
            return false;
        }
        this.bufferSize = this.endBuffer + n;
        for (int i = 0; i < n; ++i) {
            this.byteBuffer[this.endBuffer + i] = this.bb[i];
        }
        return true;
    }

    public boolean increaseEndBuffer() throws IOException {
        ++this.endBuffer;
        if (this.endBuffer >= this.bufferSize) {
            this.resizeByteBuffer();
            if (!this.readBufferFromFile() && this.endBuffer >= this.bufferSize) {
                return true;
            }
        }
        return false;
    }

    public byte[] removeEscapedEnclosures(byte[] field, int nrEnclosuresFound) {
        byte[] result = new byte[field.length - nrEnclosuresFound];
        int resultIndex = 0;
        for (int i = 0; i < field.length; ++i) {
            if (field[i] == this.enclosure[0]) {
                if (i + 1 < field.length && field[i + 1] == this.enclosure[0]) continue;
                result[resultIndex++] = field[i];
                continue;
            }
            result[resultIndex++] = field[i];
        }
        return result;
    }
}

