/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.salesforce;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class SalesforceStepDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = SalesforceStepMeta.class;
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'.000'Z";
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final Class<? extends SalesforceStepMeta> META_CLASS;

    public SalesforceStepDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.META_CLASS = ((Object)((Object)((SalesforceStepMeta)((Object)in)))).getClass();
    }

    protected abstract void getInfo(SalesforceStepMeta var1) throws KettleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        boolean successConnection = true;
        String msgError = null;
        SalesforceConnection connection = null;
        String realUsername = null;
        try {
            SalesforceStepMeta meta = this.META_CLASS.newInstance();
            this.getInfo(meta);
            String realURL = this.transMeta.environmentSubstitute(meta.getTargetURL());
            realUsername = this.transMeta.environmentSubstitute(meta.getUsername());
            String realPassword = Utils.resolvePassword((VariableSpace)this.transMeta, (String)meta.getPassword());
            int realTimeOut = Const.toInt((String)this.transMeta.environmentSubstitute(meta.getTimeout()), (int)0);
            connection = new SalesforceConnection((LogChannelInterface)this.log, realURL, realUsername, realPassword);
            connection.setTimeOut(realTimeOut);
            connection.connect();
        }
        catch (Exception e) {
            successConnection = false;
            msgError = e.getMessage();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        if (successConnection) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceDialog.Connected.OK", (String[])new String[]{realUsername}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SalesforceDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceDialog.Connected.Title.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDialog.Connected.NOK", (String[])new String[]{realUsername}), new Exception(msgError));
        }
    }
}

