/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceupsert;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforce.SalesforceStep;
import org.pentaho.di.trans.steps.salesforceupsert.SalesforceUpsertData;
import org.pentaho.di.trans.steps.salesforceupsert.SalesforceUpsertMeta;
import org.pentaho.di.trans.steps.salesforceutils.SalesforceUtils;

public class SalesforceUpsert
extends SalesforceStep {
    private static Class<?> PKG = SalesforceUpsertMeta.class;
    private SalesforceUpsertMeta meta;
    private SalesforceUpsertData data;
    private static final String BOOLEAN = "boolean";
    private static final String STRING = "string";
    private static final String INT = "int";

    public SalesforceUpsert(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (this.data.iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.nrfields = this.meta.getUpdateLookup().length;
            if (this.data.nrfields == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.fieldnrs = new int[this.meta.getUpdateStream().length];
            for (int i = 0; i < this.meta.getUpdateStream().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FieldNotFound", (String[])new String[]{this.meta.getUpdateStream()[i]}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    @VisibleForTesting
    void writeToSalesForce(Object[] rowData) throws KettleException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.CalledWrite", (Object[])new Object[]{this.data.iBufferPos, this.meta.getBatchSizeInt()}));
            }
            if (this.data.iBufferPos < this.meta.getBatchSizeInt()) {
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                ArrayList<XmlObject> upsertfields = new ArrayList<XmlObject>();
                for (int i = 0; i < this.data.nrfields; ++i) {
                    Object object;
                    ValueMetaInterface valueMeta = this.data.inputRowMeta.getValueMeta(this.data.fieldnrs[i]);
                    if (valueMeta.isNull(object = rowData[this.data.fieldnrs[i]])) {
                        fieldsToNull.add(SalesforceUtils.getFieldToNullName(this.log, this.meta.getUpdateLookup()[i], this.meta.getUseExternalId()[i]));
                        continue;
                    }
                    Object normalObject = this.normalizeValue(valueMeta, rowData[this.data.fieldnrs[i]]);
                    if (this.data.mapData && this.data.dataTypeMap != null) {
                        normalObject = this.mapDataTypes(valueMeta.getType(), this.meta.getUpdateLookup()[i], normalObject);
                    }
                    upsertfields.add(SalesforceConnection.createMessageElement(this.meta.getUpdateLookup()[i], normalObject, this.meta.getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(this.data.connection.getModule());
                if (upsertfields.size() > 0) {
                    for (XmlObject element : upsertfields) {
                        this.setFieldInSObject(sobjPass, element);
                    }
                }
                if (fieldsToNull.size() > 0) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                this.data.sfBuffer[this.data.iBufferPos] = sobjPass;
                this.data.outputBuffer[this.data.iBufferPos] = rowData;
                ++this.data.iBufferPos;
            }
            if (this.data.iBufferPos >= this.meta.getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed("Calling flush buffer from writeToSalesForce");
                }
                this.flushBuffers();
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedInWrite", (String[])new String[]{e.toString()}));
        }
    }

    void setFieldInSObject(SObject sobjPass, XmlObject element) {
        Iterator children = element.getChildren();
        String name = element.getName().getLocalPart();
        if (!children.hasNext()) {
            sobjPass.setSObjectField(name, element.getValue());
        } else {
            SObject child = new SObject();
            child.setName(new QName(name));
            while (children.hasNext()) {
                this.setFieldInSObject(child, (XmlObject)children.next());
            }
            sobjPass.setSObjectField(name, (Object)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws KettleException {
        try {
            if (this.data.sfBuffer.length > this.data.iBufferPos) {
                SObject[] smallBuffer = new SObject[this.data.iBufferPos];
                System.arraycopy(this.data.sfBuffer, 0, smallBuffer, 0, this.data.iBufferPos);
                this.data.sfBuffer = smallBuffer;
            }
            this.data.upsertResult = this.data.connection.upsert(this.meta.getUpsertField(), this.data.sfBuffer);
            int nr = this.data.upsertResult.length;
            for (int j = 0; j < nr; ++j) {
                if (this.data.upsertResult[j].isSuccess()) {
                    String id = this.data.upsertResult[j].getId();
                    if (this.data.upsertResult[j].isCreated()) {
                        this.incrementLinesOutput();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectCreated", (String[])new String[]{id}));
                        }
                    } else {
                        this.incrementLinesUpdated();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectUpdated", (String[])new String[]{id}));
                        }
                    }
                    Object[] newRow = RowDataUtil.resizeArray((Object[])this.data.outputBuffer[j], (int)this.data.outputRowMeta.size());
                    if (this.data.realSalesforceFieldName != null) {
                        int newIndex = this.data.inputRowMeta.size();
                        newRow[newIndex++] = id;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.NewRow", (Object[])new Object[]{newRow[0]}));
                    }
                    this.putRow(this.data.outputRowMeta, newRow);
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
                    continue;
                }
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ErrorFound", (String[])new String[0]));
                    }
                    Error err = this.data.upsertResult[j].getErrors()[0];
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()}));
                }
                String errorMessage = "";
                for (int i = 0; i < this.data.upsertResult[j].getErrors().length; ++i) {
                    Error err = this.data.upsertResult[j].getErrors()[i];
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUpsert.PassingRowToErrorStep", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), this.data.outputBuffer[j], 1L, errorMessage, null, "SalesforceUpsert001");
            }
            this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                if (e instanceof KettleException) {
                    throw (KettleException)((Object)e);
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedUpsert", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error step");
            }
            for (int i = 0; i < this.data.iBufferPos; ++i) {
                this.putError(this.data.inputRowMeta, this.data.outputBuffer[i], 1L, e.getMessage(), null, "SalesforceUpsert002");
            }
        }
        finally {
            if (this.data.upsertResult != null) {
                this.data.upsertResult = null;
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceUpsertMeta)smi;
        this.data = (SalesforceUpsertData)sdi;
        this.data.mapData = "true".equalsIgnoreCase(System.getProperties().getProperty("MAP_SALESFORCE_UPSERT_DATA_TYPES"));
        if (super.init(smi, sdi)) {
            try {
                Field[] fields;
                String salesfoceIdFieldname = this.environmentSubstitute(this.meta.getSalesforceIDFieldName());
                if (!Utils.isEmpty((CharSequence)salesfoceIdFieldname)) {
                    this.data.realSalesforceFieldName = salesfoceIdFieldname;
                }
                this.data.connection.setRollbackAllChangesOnError(this.meta.isRollbackAllChangesOnError());
                this.data.connection.connect();
                if (this.data.mapData && (fields = this.data.connection.getObjectFields(this.environmentSubstitute(this.meta.getModule()))) != null) {
                    this.data.dataTypeMap = this.mapDataTypesToFields(fields);
                }
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.outputBuffer != null) {
            this.data.outputBuffer = null;
        }
        if (this.data.sfBuffer != null) {
            this.data.sfBuffer = null;
        }
        super.dispose(smi, sdi);
    }

    private Map<String, String> mapDataTypesToFields(Field[] fields) {
        HashMap<String, String> mappedFields = new HashMap<String, String>();
        for (Field f : fields) {
            String fieldType = f.getType().toString();
            if ("base64".equalsIgnoreCase(fieldType) || "date".equalsIgnoreCase(fieldType) || "datetime".equalsIgnoreCase(fieldType) || INT.equalsIgnoreCase(fieldType) || "double".equalsIgnoreCase(fieldType) || BOOLEAN.equalsIgnoreCase(fieldType)) {
                mappedFields.put(f.getName(), fieldType);
                continue;
            }
            mappedFields.put(f.getName(), STRING);
        }
        return mappedFields;
    }

    private Object mapDataTypes(int type, String name, Object value) {
        try {
            switch (type) {
                case 5: {
                    if (STRING.equalsIgnoreCase(this.data.dataTypeMap.get(name))) {
                        value = String.valueOf(value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(this.data.dataTypeMap.get(name))) break;
                    int i = (Integer)value;
                    if (i == 0 || i == 1) {
                        value = i == 1;
                    }
                    break;
                }
                case 4: {
                    if (!STRING.equalsIgnoreCase(this.data.dataTypeMap.get(name))) break;
                    value = String.valueOf(value);
                    break;
                }
                case 1: {
                    if (STRING.equalsIgnoreCase(this.data.dataTypeMap.get(name))) {
                        value = String.valueOf(value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(this.data.dataTypeMap.get(name))) break;
                    Double d = (Double)value;
                    if (0.0 <= d && d < 2.0) {
                        value = d.intValue() == 1;
                    }
                    break;
                }
                case 2: {
                    if (INT.equalsIgnoreCase(this.data.dataTypeMap.get(name))) {
                        value = Integer.valueOf((String)value);
                        break;
                    }
                    if (!BOOLEAN.equalsIgnoreCase(this.data.dataTypeMap.get(name))) break;
                    if ("true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value)) {
                        value = Boolean.valueOf((String)value);
                        break;
                    }
                    if (((String)value).startsWith("-")) break;
                    Double d = Double.parseDouble((String)value);
                    if (0.0 <= d && d < 2.0) {
                        value = d.intValue() == 1;
                    }
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

