/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforce;

import com.google.common.primitives.Ints;
import java.util.Calendar;
import java.util.TimeZone;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepData;
import org.pentaho.di.trans.steps.salesforce.SalesforceStepMeta;

public abstract class SalesforceStep
extends BaseStep
implements StepInterface {
    public static Class<?> PKG = SalesforceStep.class;
    public SalesforceStepMeta meta;
    public SalesforceStepData data;

    public SalesforceStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        if (!super.init(smi, sdi)) {
            return false;
        }
        this.meta = (SalesforceStepMeta)smi;
        this.data = (SalesforceStepData)sdi;
        String realUrl = this.environmentSubstitute(this.meta.getTargetURL());
        String realUsername = this.environmentSubstitute(this.meta.getUsername());
        String realPassword = this.environmentSubstitute(this.meta.getPassword());
        String realModule = this.environmentSubstitute(this.meta.getModule());
        if (Utils.isEmpty((CharSequence)realUrl)) {
            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceStep.TargetURLMissing.Error", (String[])new String[0]));
            return false;
        }
        if (Utils.isEmpty((CharSequence)realUsername)) {
            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.UsernameMissing.Error", (String[])new String[0]));
            return false;
        }
        if (Utils.isEmpty((CharSequence)realPassword)) {
            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.PasswordMissing.Error", (String[])new String[0]));
            return false;
        }
        if (Utils.isEmpty((CharSequence)realModule)) {
            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.ModuleMissing.DialogMessage", (String[])new String[0]));
            return false;
        }
        try {
            this.data.connection = new SalesforceConnection(this.log, realUrl, realUsername, realPassword);
            this.data.connection.setModule(realModule);
            this.data.connection.setTimeOut(Const.toInt((String)this.environmentSubstitute(this.meta.getTimeout()), (int)0));
            this.data.connection.setUsingCompression(this.meta.isCompression());
        }
        catch (KettleException ke) {
            this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
            return false;
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.connection != null) {
            try {
                this.data.connection.close();
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
            this.data.connection = null;
        }
        super.dispose(smi, sdi);
    }

    public Object normalizeValue(ValueMetaInterface valueMeta, Object value) throws KettleValueException {
        if (valueMeta.isDate()) {
            Calendar cal = Calendar.getInstance(valueMeta.getDateFormatTimeZone());
            cal.setTime(valueMeta.getDate(value));
            Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            utc.clear();
            utc.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
            value = utc;
        } else if (valueMeta.isStorageBinaryString()) {
            value = valueMeta.convertToNormalStorageType(value);
        }
        if (5 == valueMeta.getType()) {
            value = Ints.checkedCast((long)((Long)value));
        }
        return value;
    }
}

