/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import com.jcraft.jsch.Session;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.pentaho.di.core.vfs.SftpFileSystemWindows;

public class SftpFileSystemWindowsProvider
extends SftpFileProvider {
    static Session createSession(GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fileSystemOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            Session session = SftpClientFactory.createConnection((String)rootName.getHostName(), (int)rootName.getPort(), (char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)rootName.getUserName())), (char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)rootName.getPassword())), (FileSystemOptions)fileSystemOptions);
            return session;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)rootName, (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new SftpFileSystemWindows((GenericFileName)name, SftpFileSystemWindowsProvider.createSession((GenericFileName)name, fileSystemOptions), fileSystemOptions);
    }
}

