/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.WeakRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.pentaho.di.connections.vfs.VFSHelper;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.UUIDUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.ConcurrentFileSystemManager;
import org.pentaho.di.core.vfs.configuration.IKettleFileSystemConfigBuilder;
import org.pentaho.di.core.vfs.configuration.KettleFileSystemConfigBuilderFactory;
import org.pentaho.di.core.vfs.configuration.KettleGenericFileSystemConfigBuilder;
import org.pentaho.di.i18n.BaseMessages;

public class KettleVFS {
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String CONNECTION = "connection";
    private static Class<?> PKG = KettleVFS.class;
    private static final KettleVFS kettleVFS = new KettleVFS();
    private final DefaultFileSystemManager fsm = new ConcurrentFileSystemManager();
    private static final int TIMEOUT_LIMIT = 9000;
    private static final int TIME_TO_SLEEP_STEP = 50;
    private static final String PROVIDER_PATTERN_SCHEME = "^[\\w\\d]+://(.*)";
    private static VariableSpace defaultVariableSpace = new Variables();

    private KettleVFS() {
        VFS.setManager((FileSystemManager)this.fsm);
        try {
            this.fsm.setFilesCache((FilesCache)new WeakRefFilesCache());
            this.fsm.init();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (KettleVFS.this.fsm != null) {
                    try {
                        KettleVFS.this.fsm.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }));
    }

    public FileSystemManager getFileSystemManager() {
        return this.fsm;
    }

    public static KettleVFS getInstance() {
        return kettleVFS;
    }

    public static FileObject getFileObject(String vfsFilename) throws KettleFileException {
        return KettleVFS.getFileObject(vfsFilename, defaultVariableSpace);
    }

    public static FileObject getFileObject(String vfsFilename, VariableSpace space) throws KettleFileException {
        return KettleVFS.getFileObject(vfsFilename, space, null);
    }

    public static FileObject getFileObject(String vfsFilename, FileSystemOptions fsOptions) throws KettleFileException {
        return KettleVFS.getFileObject(vfsFilename, defaultVariableSpace, fsOptions);
    }

    public static FileObject getFileObject(String vfsFilename, VariableSpace space, FileSystemOptions fsOptions) throws KettleFileException {
        if (vfsFilename == null) {
            throw new IllegalArgumentException("Unexpected null VFS filename.");
        }
        try {
            FileSystemManager fsManager = KettleVFS.getInstance().getFileSystemManager();
            String[] schemes = fsManager.getSchemes();
            String scheme = KettleVFS.getScheme(schemes, vfsFilename);
            if (KettleVFS.hasSchemePattern(vfsFilename, PROVIDER_PATTERN_SCHEME)) {
                for (int timeOut = 9000; scheme == null && timeOut > 0; timeOut -= 50) {
                    schemes = fsManager.getSchemes();
                    try {
                        Thread.sleep(50L);
                        scheme = KettleVFS.getScheme(schemes, vfsFilename);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            fsOptions = KettleVFS.getFileSystemOptions(scheme, vfsFilename, space, fsOptions);
            String filename = KettleVFS.normalizePath(vfsFilename, scheme);
            return fsOptions != null ? fsManager.resolveFile(filename, fsOptions) : fsManager.resolveFile(filename);
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to get VFS File object for filename '" + KettleVFS.cleanseFilename(vfsFilename) + "' : " + e.getMessage(), e);
        }
    }

    protected static String normalizePath(String path, String scheme) {
        String normalizedPath = path;
        if (path.startsWith("\\\\")) {
            File file = new File(path);
            normalizedPath = file.toURI().toString();
        } else if (scheme == null) {
            File file = new File(path);
            normalizedPath = file.getAbsolutePath();
        }
        return normalizedPath;
    }

    protected static boolean hasSchemePattern(String path, String patternString) {
        boolean hasScheme = false;
        Pattern pattern = Pattern.compile(patternString);
        if (pattern != null) {
            Matcher matcher = pattern.matcher(path);
            hasScheme = matcher.matches();
        }
        return hasScheme;
    }

    static String getScheme(String[] schemes, String fileName) {
        for (String scheme : schemes) {
            if (!fileName.startsWith(scheme + ":")) continue;
            return scheme;
        }
        return null;
    }

    static FileSystemOptions getFileSystemOptions(String scheme, String vfsFilename, VariableSpace space, FileSystemOptions fileSystemOptions) throws IOException {
        if (scheme == null) {
            return fileSystemOptions;
        }
        return KettleVFS.buildFsOptions(space, fileSystemOptions, vfsFilename, scheme);
    }

    private static String cleanseFilename(String vfsFilename) {
        return vfsFilename.replaceAll(":[^:@/]+@", ":<password>@");
    }

    private static FileSystemOptions buildFsOptions(VariableSpace varSpace, FileSystemOptions sourceOptions, String vfsFilename, String scheme) throws IOException {
        String[] varList;
        if (varSpace == null || vfsFilename == null) {
            return null;
        }
        IKettleFileSystemConfigBuilder configBuilder = KettleFileSystemConfigBuilderFactory.getConfigBuilder(varSpace, scheme);
        FileSystemOptions fsOptions = sourceOptions == null ? new FileSystemOptions() : sourceOptions;
        for (String var : varList = varSpace.listVariables()) {
            FileSystemOptions fileSystemOptions;
            if (var.equalsIgnoreCase(CONNECTION) && varSpace.getVariable(var) != null && (fileSystemOptions = VFSHelper.getOpts(vfsFilename, varSpace.getVariable(var))) != null) {
                return fileSystemOptions;
            }
            if (!var.startsWith("vfs.")) continue;
            String param = configBuilder.parseParameterName(var, scheme);
            String varScheme = KettleGenericFileSystemConfigBuilder.extractScheme(var);
            if (param != null) {
                if (varScheme != null && !varScheme.equals("sftp") && !varScheme.equals(scheme)) continue;
                configBuilder.setParameter(fsOptions, param, varSpace.getVariable(var), var, vfsFilename);
                continue;
            }
            throw new IOException("FileSystemConfigBuilder could not parse parameter: " + var);
        }
        return fsOptions;
    }

    public static String getTextFileContent(String vfsFilename, String charSetName) throws KettleFileException {
        return KettleVFS.getTextFileContent(vfsFilename, null, charSetName);
    }

    public static String getTextFileContent(String vfsFilename, VariableSpace space, String charSetName) throws KettleFileException {
        try {
            int c;
            InputStream inputStream = null;
            inputStream = space == null ? KettleVFS.getInputStream(vfsFilename) : KettleVFS.getInputStream(vfsFilename, space);
            InputStreamReader reader = new InputStreamReader(inputStream, charSetName);
            StringBuilder aBuffer = new StringBuilder();
            while ((c = reader.read()) != -1) {
                aBuffer.append((char)c);
            }
            reader.close();
            inputStream.close();
            return aBuffer.toString();
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
    }

    public static boolean fileExists(String vfsFilename) throws KettleFileException {
        return KettleVFS.fileExists(vfsFilename, null);
    }

    public static boolean fileExists(String vfsFilename, VariableSpace space) throws KettleFileException {
        FileObject fileObject = null;
        try {
            fileObject = KettleVFS.getFileObject(vfsFilename, space);
            boolean bl = fileObject.exists();
            return bl;
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
        finally {
            if (fileObject != null) {
                try {
                    fileObject.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static InputStream getInputStream(FileObject fileObject) throws FileSystemException {
        FileContent content = fileObject.getContent();
        return content.getInputStream();
    }

    public static InputStream getInputStream(String vfsFilename) throws KettleFileException {
        return KettleVFS.getInputStream(vfsFilename, defaultVariableSpace);
    }

    public static InputStream getInputStream(String vfsFilename, VariableSpace space) throws KettleFileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject(vfsFilename, space);
            return KettleVFS.getInputStream(fileObject);
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
    }

    public static OutputStream getOutputStream(FileObject fileObject, boolean append) throws IOException {
        FileObject parent = fileObject.getParent();
        if (parent != null && !parent.exists()) {
            throw new IOException(BaseMessages.getString(PKG, "KettleVFS.Exception.ParentDirectoryDoesNotExist", KettleVFS.getFriendlyURI(parent)));
        }
        try {
            fileObject.createFile();
            FileContent content = fileObject.getContent();
            return content.getOutputStream(append);
        }
        catch (FileSystemException e) {
            if (fileObject instanceof LocalFile) {
                try {
                    String filename = KettleVFS.getFilename(fileObject);
                    return new FileOutputStream(new File(filename), append);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public static OutputStream getOutputStream(String vfsFilename, boolean append) throws KettleFileException {
        return KettleVFS.getOutputStream(vfsFilename, defaultVariableSpace, append);
    }

    public static OutputStream getOutputStream(String vfsFilename, VariableSpace space, boolean append) throws KettleFileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject(vfsFilename, space);
            return KettleVFS.getOutputStream(fileObject, append);
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
    }

    public static OutputStream getOutputStream(String vfsFilename, VariableSpace space, FileSystemOptions fsOptions, boolean append) throws KettleFileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject(vfsFilename, space, fsOptions);
            return KettleVFS.getOutputStream(fileObject, append);
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
    }

    public static String getFilename(FileObject fileObject) {
        FileName fileName = fileObject.getName();
        String root = fileName.getRootURI();
        if (!root.startsWith("file:")) {
            return fileName.getURI();
        }
        if (root.startsWith("file:////")) {
            return fileName.getURI();
        }
        root = root.endsWith(":/") ? root.substring(8, 10) : "";
        String fileString = root + fileName.getPath();
        if (!"/".equals(Const.FILE_SEPARATOR)) {
            fileString = Const.replace(fileString, "/", Const.FILE_SEPARATOR);
        }
        return fileString;
    }

    public static String getFriendlyURI(String filename) {
        String friendlyName;
        if (filename == null) {
            return null;
        }
        try {
            friendlyName = KettleVFS.getFriendlyURI(KettleVFS.getFileObject(filename));
        }
        catch (Exception e) {
            friendlyName = KettleVFS.cleanseFilename(filename);
        }
        return friendlyName;
    }

    public static String getFriendlyURI(FileObject fileObject) {
        return fileObject.getName().getFriendlyURI();
    }

    public static FileObject createTempFile(String prefix, Suffix suffix) throws KettleFileException {
        return KettleVFS.createTempFile(prefix, suffix, TEMP_DIR);
    }

    public static FileObject createTempFile(String prefix, Suffix suffix, VariableSpace variableSpace) throws KettleFileException {
        return KettleVFS.createTempFile(prefix, suffix, TEMP_DIR, variableSpace);
    }

    public static FileObject createTempFile(String prefix, Suffix suffix, String directory) throws KettleFileException {
        return KettleVFS.createTempFile(prefix, suffix, directory, null);
    }

    public static FileObject createTempFile(String prefix, String suffix, String directory) throws KettleFileException {
        return KettleVFS.createTempFile(prefix, suffix, directory, null);
    }

    public static FileObject createTempFile(String prefix, Suffix suffix, String directory, VariableSpace space) throws KettleFileException {
        return KettleVFS.createTempFile(prefix, suffix.ext, directory, space);
    }

    public static FileObject createTempFile(String prefix, String suffix, String directory, VariableSpace space) throws KettleFileException {
        try {
            String filename;
            FileObject fileObject;
            while ((fileObject = KettleVFS.getFileObject(filename = new StringBuilder(50).append(directory).append('/').append(prefix).append('_').append(UUIDUtil.getUUIDAsString()).append(suffix).toString(), space)).exists()) {
            }
            return fileObject;
        }
        catch (IOException e) {
            throw new KettleFileException(e);
        }
    }

    public static Comparator<FileObject> getComparator() {
        return new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                String filename1 = KettleVFS.getFilename(o1);
                String filename2 = KettleVFS.getFilename(o2);
                return filename1.compareTo(filename2);
            }
        };
    }

    @Deprecated
    public static FileInputStream getFileInputStream(FileObject fileObject) throws IOException {
        if (!(fileObject instanceof LocalFile)) {
            throw new IOException(BaseMessages.getString(PKG, "FixedInput.Log.OnlyLocalFilesAreSupported", new String[0]));
        }
        return new FileInputStream(fileObject.getName().getPathDecoded());
    }

    public static boolean startsWithScheme(String vfsFileName) {
        FileSystemManager fsManager = KettleVFS.getInstance().getFileSystemManager();
        boolean found = false;
        String[] schemes = fsManager.getSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            if (!vfsFileName.startsWith(schemes[i] + ":")) continue;
            found = true;
            break;
        }
        return found;
    }

    public static void closeEmbeddedFileSystem(String embeddedMetastoreKey) {
        if (KettleVFS.getInstance().getFileSystemManager() instanceof ConcurrentFileSystemManager) {
            ((ConcurrentFileSystemManager)KettleVFS.getInstance().getFileSystemManager()).closeEmbeddedFileSystem(embeddedMetastoreKey);
        }
    }

    public void reset() {
        defaultVariableSpace = new Variables();
        defaultVariableSpace.initializeVariablesFrom(null);
        this.fsm.close();
        try {
            this.fsm.setFilesCache((FilesCache)new WeakRefFilesCache());
            this.fsm.init();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public static void freeUnusedResources() {
        ((StandardFileSystemManager)KettleVFS.getInstance().getFileSystemManager()).freeUnusedResources();
    }

    static {
        defaultVariableSpace.initializeVariablesFrom(null);
    }

    public static enum Suffix {
        ZIP(".zip"),
        TMP(".tmp"),
        JAR(".jar");

        private String ext;

        private Suffix(String ext) {
            this.ext = ext;
        }
    }
}

