/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging.log4j;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.log4j.Log4jLayout;
import org.pentaho.di.core.vfs.KettleVFS;

public class Log4jFileAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private FileObject file;
    private String name;
    private OutputStream fileOutputStream;

    public Log4jFileAppender(FileObject file) throws IOException {
        this.file = file;
        this.fileOutputStream = KettleVFS.getOutputStream(file, false);
    }

    public Log4jFileAppender(FileObject file, boolean append) throws IOException {
        this.file = file;
        this.fileOutputStream = KettleVFS.getOutputStream(file, append);
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
        try {
            this.fileOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Unable to close Logging file [" + this.file.getName() + "] : " + e.getMessage());
        }
    }

    public void append(LogEvent event) {
        String line = ((Log4jLayout)this.layout).format(event) + Const.CR;
        try {
            this.fileOutputStream.write(line.getBytes("UTF-8"));
        }
        catch (IOException e) {
            System.out.println("Unable to close Logging file [" + this.file.getName() + "] : " + e.getMessage());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean ignoreExceptions() {
        return false;
    }

    public ErrorHandler getHandler() {
        return null;
    }

    public void setHandler(ErrorHandler handler) {
    }

    public boolean requiresLayout() {
        return true;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFilename(FileObject file) {
        this.file = file;
    }

    public OutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    public void setFileOutputStream(OutputStream fileOutputStream) {
        this.fileOutputStream = fileOutputStream;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public LifeCycle.State getState() {
        return null;
    }

    public void initialize() {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }
}

