/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging.log4j;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.log4j.Log4jKettleLayout;

public class KettleLogChannelAppender
implements Appender {
    public static final Map<LogLevel, Level> LOG_LEVEL_MAP;
    private final LogChannelInterface kettleLogChannelInterface;
    private final Layout<String> layout;
    private volatile LifeCycle.State state;
    private ErrorHandler errorHandler;

    public KettleLogChannelAppender(LogChannelInterface log, Log4jKettleLayout layout) {
        this.kettleLogChannelInterface = log;
        this.layout = layout;
        this.state = LifeCycle.State.INITIALIZED;
        this.errorHandler = new ErrorHandler(){

            public void error(String msg) {
                KettleLogChannelAppender.this.kettleLogChannelInterface.logError(msg);
            }

            public void error(String msg, Throwable t) {
                KettleLogChannelAppender.this.kettleLogChannelInterface.logError(msg, t);
            }

            public void error(String msg, LogEvent event, Throwable t) {
                KettleLogChannelAppender.this.kettleLogChannelInterface.logError(msg, t);
            }
        };
    }

    public void append(LogEvent event) {
        String s = (String)((Object)this.layout.toSerializable(event));
        if (Level.DEBUG.equals((Object)event.getLevel())) {
            this.kettleLogChannelInterface.logDebug(s);
        } else if (Level.ERROR.equals((Object)event.getLevel()) || Level.FATAL.equals((Object)event.getLevel())) {
            Throwable t = event.getThrown();
            if (t == null) {
                this.kettleLogChannelInterface.logError(s);
            } else {
                this.kettleLogChannelInterface.logError(s, t);
            }
        } else if (Level.TRACE.equals((Object)event.getLevel())) {
            this.kettleLogChannelInterface.logRowlevel(s);
        } else if (Level.OFF.equals((Object)event.getLevel())) {
            this.kettleLogChannelInterface.logMinimal(s);
        } else {
            this.kettleLogChannelInterface.logBasic(s);
        }
    }

    public String getName() {
        return this.kettleLogChannelInterface.getLogChannelId();
    }

    public Layout<? extends Serializable> getLayout() {
        return this.layout;
    }

    public boolean ignoreExceptions() {
        return true;
    }

    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public LifeCycle.State getState() {
        return this.state;
    }

    public void initialize() {
    }

    public void start() {
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return LifeCycle.State.STARTED.equals((Object)this.state);
    }

    public boolean isStopped() {
        return LifeCycle.State.STOPPED.equals((Object)this.state);
    }

    static {
        EnumMap<LogLevel, Level> map = new EnumMap<LogLevel, Level>(LogLevel.class);
        map.put(LogLevel.BASIC, Level.INFO);
        map.put(LogLevel.MINIMAL, Level.INFO);
        map.put(LogLevel.DEBUG, Level.DEBUG);
        map.put(LogLevel.ERROR, Level.ERROR);
        map.put(LogLevel.DETAILED, Level.INFO);
        map.put(LogLevel.ROWLEVEL, Level.DEBUG);
        map.put(LogLevel.NOTHING, Level.OFF);
        LOG_LEVEL_MAP = Collections.unmodifiableMap(map);
    }
}

