/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelFileWriterBuffer;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.util.EnvUtil;

public class LoggingRegistry {
    private static LoggingRegistry registry = new LoggingRegistry();
    private Map<String, LoggingObjectInterface> map;
    private Map<String, LogChannelFileWriterBuffer> fileWriterBuffers;
    private Map<String, List<String>> childrenMap;
    private Queue<LoggingObjectInterface> registerPurgeQueue;
    private Date lastModificationTime;
    private int maxSize;
    private static final int DEFAULT_MAX_SIZE = 10000;
    private Timer purgeTimer;
    private int purgeTimeout;
    private static final int DEFAULT_PURGE_TIMER = 60000;
    private int purgeTimerCount = 0;
    private int purgedObjectCount = 0;
    private int foundCounter = 0;
    private final Object syncObject = new Object();

    private LoggingRegistry() {
        this.map = new ConcurrentHashMap<String, LoggingObjectInterface>();
        this.childrenMap = new ConcurrentHashMap<String, List<String>>();
        this.fileWriterBuffers = new ConcurrentHashMap<String, LogChannelFileWriterBuffer>();
        this.registerPurgeQueue = new ConcurrentLinkedQueue<LoggingObjectInterface>();
        this.lastModificationTime = new Date();
        this.updateFromProperties();
        this.installPurgeTimer();
    }

    public static LoggingRegistry getInstance() {
        return registry;
    }

    public String registerLoggingSource(Object object) {
        return this.registerLoggingSource(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerLoggingSource(Object object, boolean isPurgeable) {
        String foundLogChannelId;
        LoggingObject loggingSource = new LoggingObject(object);
        LoggingObjectInterface found = this.findExistingLoggingSource(loggingSource);
        if (found != null && !(foundLogChannelId = this.determineExistingLoggingSource(loggingSource, found)).isEmpty()) {
            ++this.foundCounter;
            return foundLogChannelId;
        }
        Object object2 = this.syncObject;
        synchronized (object2) {
            String parentLogChannelId;
            String logChannelId = UUID.randomUUID().toString();
            loggingSource.setLogChannelId(logChannelId);
            this.map.put(logChannelId, loggingSource);
            if (loggingSource.getParent() != null && (parentLogChannelId = loggingSource.getParent().getLogChannelId()) != null) {
                List parentChildren = this.childrenMap.computeIfAbsent(parentLogChannelId, k -> new ArrayList());
                parentChildren.add(logChannelId);
            }
            this.lastModificationTime = new Date();
            loggingSource.setRegistrationDate(this.lastModificationTime);
            if (isPurgeable) {
                this.registerPurgeQueue.add(loggingSource);
            }
            return logChannelId;
        }
    }

    public LoggingObjectInterface findExistingLoggingSource(LoggingObjectInterface loggingObject) {
        LoggingObjectInterface found = null;
        for (LoggingObjectInterface verify : this.map.values()) {
            if (!loggingObject.equals(verify)) continue;
            found = verify;
            break;
        }
        return found;
    }

    private String determineExistingLoggingSource(LoggingObjectInterface loggingSource, LoggingObjectInterface foundSource) {
        LoggingObjectInterface foundParent = foundSource.getParent();
        LoggingObjectInterface loggingSourceParent = loggingSource.getParent();
        String foundLogChannelId = foundSource.getLogChannelId();
        if (!foundLogChannelId.isEmpty()) {
            if (foundParent != null && loggingSourceParent != null) {
                String foundParentLogChannelId = foundParent.getLogChannelId();
                String sourceParentLogChannelId = loggingSourceParent.getLogChannelId();
                if (foundParentLogChannelId != null && foundParentLogChannelId.equals(sourceParentLogChannelId)) {
                    return foundLogChannelId;
                }
            }
            if (foundParent == null && loggingSourceParent == null) {
                return foundLogChannelId;
            }
        }
        return "";
    }

    public LoggingObjectInterface getLoggingObject(String logChannelId) {
        return this.map.get(logChannelId);
    }

    @Deprecated
    public Map<String, LoggingObjectInterface> getMap() {
        return this.map;
    }

    public void updateFromProperties() {
        this.maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOGGING_REGISTRY_SIZE"), 10000);
        this.purgeTimeout = Const.toInt(EnvUtil.getSystemProperty("KETTLE_LOGGING_REGISTRY_PURGE_TIMEOUT"), 60000);
    }

    public List<String> getLogChannelChildren(String parentLogChannelId) {
        if (parentLogChannelId == null) {
            return new ArrayList<String>();
        }
        List<String> list = this.getLogChannelChildren(new ArrayList<String>(), parentLogChannelId);
        list.add(parentLogChannelId);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLogChannelChildren(List<String> children, String parentLogChannelId) {
        Object object = this.syncObject;
        synchronized (object) {
            List<String> list = this.childrenMap.get(parentLogChannelId);
            if (list == null) {
                return children;
            }
            for (String logChannelId : list) {
                this.getLogChannelChildren(children, logChannelId);
                children.add(logChannelId);
            }
        }
        return children;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public String dump(boolean includeGeneral) {
        StringBuilder out = new StringBuilder(50000);
        for (LoggingObjectInterface o : this.map.values()) {
            if (!includeGeneral && o.getObjectType().equals((Object)LoggingObjectType.GENERAL)) continue;
            out.append(o.getContainerObjectId());
            out.append("\t");
            out.append(o.getLogChannelId());
            out.append("\t");
            out.append(o.getObjectType().name());
            out.append("\t");
            out.append(o.getObjectName());
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getLogChannelId() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectType().name() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectName() : "-");
            out.append("\n");
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncludingChildren(String logChannelId) {
        Object object = this.syncObject;
        synchronized (object) {
            List<String> children = this.getLogChannelChildren(logChannelId);
            for (String child : children) {
                this.map.remove(child);
            }
            this.map.remove(logChannelId);
            this.removeOrphans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrphans() {
        Object object = this.syncObject;
        synchronized (object) {
            this.childrenMap.keySet().retainAll(this.map.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLogChannelFileWriterBuffer(LogChannelFileWriterBuffer fileWriterBuffer) {
        Object object = this.syncObject;
        synchronized (object) {
            this.fileWriterBuffers.put(fileWriterBuffer.getLogChannelId(), fileWriterBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogChannelFileWriterBuffer getLogChannelFileWriterBuffer(String id) {
        Object object = this.syncObject;
        synchronized (object) {
            LogChannelFileWriterBuffer fileWriterBuffer = this.fileWriterBuffers.get(id);
            if (fileWriterBuffer != null) {
                return fileWriterBuffer;
            }
            ConcurrentHashMap<LogChannelFileWriterBuffer, List<String>> possibleWriters = new ConcurrentHashMap<LogChannelFileWriterBuffer, List<String>>();
            for (Map.Entry<String, LogChannelFileWriterBuffer> entry : this.fileWriterBuffers.entrySet()) {
                String bufferId = entry.getKey();
                List<String> logChannelChildren = this.getLogChannelChildren(bufferId);
                if (!logChannelChildren.contains(id)) continue;
                possibleWriters.put(entry.getValue(), logChannelChildren);
            }
            return this.determineLogChannelFileWriterBuffer(possibleWriters);
        }
    }

    private LogChannelFileWriterBuffer determineLogChannelFileWriterBuffer(ConcurrentHashMap<LogChannelFileWriterBuffer, List<String>> possibleWriters) {
        if (possibleWriters.size() == 1) {
            return possibleWriters.keys().nextElement();
        }
        Enumeration<LogChannelFileWriterBuffer> possibleWritersIds = possibleWriters.keys();
        while (possibleWritersIds.hasMoreElements()) {
            LogChannelFileWriterBuffer writer = possibleWritersIds.nextElement();
            for (Map.Entry<LogChannelFileWriterBuffer, List<String>> entry : possibleWriters.entrySet()) {
                if (entry.getKey().equals(writer) || entry.getValue().contains(writer.getLogChannelId())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    protected Set<String> getLogChannelFileWriterBufferIds() {
        Set<String> bufferIds = this.fileWriterBuffers.keySet();
        HashSet<String> ids = new HashSet<String>();
        for (String id : bufferIds) {
            ids.addAll(this.getLogChannelChildren(id));
        }
        ids.addAll(bufferIds);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogChannelFileWriterBuffer(String id) {
        Object object = this.syncObject;
        synchronized (object) {
            Set<String> bufferIds = this.fileWriterBuffers.keySet();
            for (String bufferId : bufferIds) {
                if (!this.getLogChannelChildren(id).contains(bufferId)) continue;
                this.fileWriterBuffers.remove(bufferId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.syncObject;
        synchronized (object) {
            this.map.clear();
            this.childrenMap.clear();
            this.fileWriterBuffers.clear();
            this.registerPurgeQueue.clear();
            this.purgeTimerCount = 0;
            this.purgedObjectCount = 0;
            this.foundCounter = 0;
            if (this.purgeTimer != null) {
                this.purgeTimer.cancel();
                this.purgeTimer.purge();
                this.purgeTimer = new Timer("LoggingRegistryPurgeTimer", true);
                this.installPurgeTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeRegistry() {
        if (this.maxSize > 0 && !this.registerPurgeQueue.isEmpty() && this.map.size() > this.maxSize) {
            Object object = this.syncObject;
            synchronized (object) {
                int cutCount = (int)((double)this.map.size() - ((double)this.maxSize - (double)this.maxSize * 0.1));
                int cutCounter = 0;
                int limitCounter = 0;
                Set<String> channelsNotToRemove = this.getLogChannelFileWriterBufferIds();
                this.logDebug(String.format("LoggingRegistry Stats:%n   CutCount= %d | channelsNotToRemoveSize= %d | MapSize= %d | PurgeQueueSize= %d ", cutCount, channelsNotToRemove.size(), this.map.size(), this.registerPurgeQueue.size()));
                if (channelsNotToRemove.size() >= (int)((double)this.maxSize * 0.9)) {
                    this.logBasic("Logging Registry is unable to purge LogChannels since there are too many active channels. We recommend increasing the LoggingRegistry Size (KETTLE_MAX_LOGGING_REGISTRY_SIZE) in kettle.properties.");
                } else {
                    cutCount -= channelsNotToRemove.size();
                    int limitSize = this.registerPurgeQueue.size();
                    do {
                        if (!this.purgeObject(channelsNotToRemove)) continue;
                        ++cutCounter;
                    } while (!this.registerPurgeQueue.isEmpty() && cutCounter < cutCount && ++limitCounter < limitSize);
                }
                this.removeOrphans();
                ++this.purgeTimerCount;
            }
        }
        this.logDebug(String.format("LoggingRegistry Stats:%n    FoundCount= %d | MapSize= %d | PurgeCount= %d | PurgeObjectCount= %d ", this.foundCounter, this.map.size(), this.purgeTimerCount, this.purgedObjectCount));
    }

    private boolean purgeObject(Set<String> channelsNotToRemove) {
        boolean result = false;
        LoggingObjectInterface obj = this.registerPurgeQueue.poll();
        if (obj != null && !obj.getLogChannelId().isEmpty()) {
            String objId = obj.getLogChannelId();
            if (!channelsNotToRemove.contains(objId)) {
                this.map.remove(objId);
                ++this.purgedObjectCount;
                result = true;
            } else {
                this.registerPurgeQueue.add(obj);
            }
        }
        return result;
    }

    private void logDebug(String msg) {
        try {
            if (KettleLogStore.isInitialized()) {
                LogChannel.GENERAL.logDebug(msg);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void logError(String msg) {
        try {
            if (KettleLogStore.isInitialized()) {
                LogChannel.GENERAL.logError(msg);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void logBasic(String msg) {
        try {
            if (KettleLogStore.isInitialized()) {
                LogChannel.GENERAL.logBasic(msg);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void installPurgeTimer() {
        if (this.purgeTimer == null) {
            this.purgeTimer = new Timer("LoggingRegistryPurgeTimer", true);
        }
        final AtomicBoolean busy = new AtomicBoolean(false);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (busy.compareAndSet(false, true)) {
                    try {
                        LoggingRegistry.this.purgeRegistry();
                        LoggingRegistry.this.purgeTimerCount++;
                    }
                    finally {
                        busy.set(false);
                    }
                }
            }
        };
        this.purgeTimer.schedule(timerTask, this.purgeTimeout, (long)this.purgeTimeout);
    }

    @VisibleForTesting
    void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @VisibleForTesting
    void setPurgeTimeout(int purgeTimeout) {
        this.purgeTimeout = purgeTimeout;
    }

    @VisibleForTesting
    int getRegistryMapSize() {
        return this.map.size();
    }

    @VisibleForTesting
    int getPurgedObjectCount() {
        return this.purgedObjectCount;
    }

    @VisibleForTesting
    boolean purgeQueueContains(LoggingObjectInterface obj) {
        return this.registerPurgeQueue.contains(obj);
    }

    @VisibleForTesting
    Map<String, LoggingObjectInterface> dumpItems() {
        return Collections.unmodifiableMap(this.map);
    }

    @VisibleForTesting
    Map<String, List<String>> dumpChildren() {
        return Collections.unmodifiableMap(this.childrenMap);
    }

    @VisibleForTesting
    void invokePurge() {
        this.purgeRegistry();
    }

    @VisibleForTesting
    int getTimerHashCode() {
        return this.purgeTimer.hashCode();
    }

    @VisibleForTesting
    void setFileWriterBuffers(Map<String, LogChannelFileWriterBuffer> buffers) {
        this.fileWriterBuffers = buffers;
    }

    @VisibleForTesting
    void setChildrenMap(Map<String, List<String>> map) {
        this.childrenMap = map;
    }
}

