/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.spi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.hbase.ColumnFilter;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;

public interface HBaseConnection {
    public static final String HBASE_VERSION_KEY = "hbase.defaults.for.version";
    public static final String DEFAULTS_KEY = "hbase.default";
    public static final String SITE_KEY = "hbase.site";
    public static final String ZOOKEEPER_QUORUM_KEY = "hbase.zookeeper.quorum";
    public static final String ZOOKEEPER_PORT_KEY = "hbase.zookeeper.property.clientPort";
    public static final String ACTIVE_SHIM_VERSION = "ACTIVE_SHIM_VERSION";
    public static final String NAMED_CLUSTER = "named.cluster";
    public static final String SHIM_IS_MAPR = "shim.isMapr";
    public static final String SHIM_IDENTIFIER = "shim.identifier";
    public static final String COL_DESCRIPTOR_MAX_VERSIONS_KEY = "col.descriptor.maxVersions";
    public static final String COL_DESCRIPTOR_COMPRESSION_KEY = "col.descriptor.compression";
    public static final String COL_DESCRIPTOR_IN_MEMORY_KEY = "col.descriptor.inMemory";
    public static final String COL_DESCRIPTOR_BLOCK_CACHE_ENABLED_KEY = "col.descriptor.blockCacheEnabled";
    public static final String COL_DESCRIPTOR_BLOCK_SIZE_KEY = "col.descriptor.blockSize";
    public static final String COL_DESCRIPTOR_TIME_TO_LIVE_KEY = "col.desciptor.timeToLive";
    public static final String COL_DESCRIPTOR_BLOOM_FILTER_KEY = "col.descriptor.bloomFilter";
    public static final String COL_DESCRIPTOR_SCOPE_KEY = "col.descriptor.scope";
    public static final String HTABLE_WRITE_BUFFER_SIZE_KEY = "htable.writeBufferSize";

    public HBaseBytesUtilShim getBytesUtil() throws Exception;

    public void configureConnection(Properties var1, NamedCluster var2, List<String> var3) throws Exception;

    public void checkHBaseAvailable() throws Exception;

    public List<String> listTableNames() throws Exception;

    public boolean tableExists(String var1) throws Exception;

    public boolean isTableDisabled(String var1) throws Exception;

    public boolean isTableAvailable(String var1) throws Exception;

    public void disableTable(String var1) throws Exception;

    public void enableTable(String var1) throws Exception;

    public void deleteTable(String var1) throws Exception;

    public void executeTargetTableDelete(byte[] var1) throws Exception;

    public void createTable(String var1, List<String> var2, Properties var3) throws Exception;

    public List<String> getTableFamiles(String var1) throws Exception;

    public void newSourceTable(String var1) throws Exception;

    public boolean sourceTableRowExists(byte[] var1) throws Exception;

    public void newSourceTableScan(byte[] var1, byte[] var2, int var3) throws Exception;

    public void newTargetTablePut(byte[] var1, boolean var2) throws Exception;

    public boolean targetTableIsAutoFlush() throws Exception;

    public void executeTargetTablePut() throws Exception;

    public void flushCommitsTargetTable() throws Exception;

    public void addColumnToTargetPut(String var1, String var2, boolean var3, byte[] var4) throws Exception;

    public void addColumnFilterToScan(ColumnFilter var1, HBaseValueMeta var2, VariableSpace var3, boolean var4) throws Exception;

    public void addColumnToScan(String var1, String var2, boolean var3) throws Exception;

    public void executeSourceTableScan() throws Exception;

    public boolean resultSetNextRow() throws Exception;

    public byte[] getRowKey(Object var1) throws Exception;

    public byte[] getResultSetCurrentRowKey() throws Exception;

    public byte[] getRowColumnLatest(Object var1, String var2, String var3, boolean var4) throws Exception;

    public boolean checkForHBaseRow(Object var1);

    public byte[] getResultSetCurrentRowColumnLatest(String var1, String var2, boolean var3) throws Exception;

    public NavigableMap<byte[], byte[]> getRowFamilyMap(Object var1, String var2) throws Exception;

    public NavigableMap<byte[], byte[]> getResultSetCurrentRowFamilyMap(String var1) throws Exception;

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getRowMap(Object var1) throws Exception;

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getResultSetCurrentRowMap() throws Exception;

    public void closeSourceTable() throws Exception;

    public void closeSourceResultSet() throws Exception;

    public void newTargetTable(String var1, Properties var2) throws Exception;

    public void closeTargetTable() throws Exception;

    public boolean isImmutableBytesWritable(Object var1);

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!HBaseConnection.isEmpty(pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }

    public static boolean isEmpty(String toCheck) {
        return toCheck == null || toCheck.length() == 0;
    }

    public void close() throws Exception;

    public void obtainAuthTokenForJob(Configuration var1) throws Exception;

    public List<String> listNamespaces() throws Exception;

    public List<String> listTableNamesByNamespace(String var1) throws Exception;
}

