/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.osgi.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.di.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasRealmsRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaasRealmsRegistrar.class);
    private BundleContext bundleContext;

    public JaasRealmsRegistrar(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setRealms(String configFile) {
        try {
            HashMap<String, LinkedList<AppConfigurationEntry>> configs = new HashMap<String, LinkedList<AppConfigurationEntry>>();
            configs.putAll(this.getOverridenDefaultConfigs());
            configs.putAll(this.getMaprJaasConfig(configFile));
            ArrayList<ServiceRegistration> realmRegistrations = new ArrayList<ServiceRegistration>(configs.size());
            for (Map.Entry entry : configs.entrySet()) {
                JaasRealm realm = this.createJaasRealm(entry.getKey().toString(), (List)entry.getValue());
                ServiceRegistration reg = this.getBundleContext().registerService(JaasRealm.class.getCanonicalName(), (Object)realm, null);
                realmRegistrations.add(reg);
            }
            String debugMessage = String.format("Registered %s JAAS realms using system properties.", realmRegistrations.size());
            LOGGER.debug(debugMessage);
        }
        catch (Exception e) {
            LOGGER.error("Error during setting up MapR JAAS configuration", (Throwable)e);
        }
    }

    private HashMap<String, LinkedList<AppConfigurationEntry>> getOverridenDefaultConfigs() {
        HashMap<String, LinkedList<AppConfigurationEntry>> configs = new HashMap<String, LinkedList<AppConfigurationEntry>>();
        HashMap<String, String> options = new HashMap<String, String>();
        LinkedList<AppConfigurationEntry> entries = new LinkedList<AppConfigurationEntry>();
        options.put("useTicketCache", "true");
        options.put("doNotPrompt", "true");
        entries.add(new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options));
        configs.put("com.sun.security.jgss.krb5.initiate", entries);
        return configs;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, LinkedList<AppConfigurationEntry>> getMaprJaasConfig(String configFile) {
        try {
            HashMap configs;
            if (Utils.isEmpty((CharSequence)System.getProperty("java.security.auth.login.config"))) {
                this.getClass().getClassLoader().loadClass("com.mapr.baseutils.JVMProperties").newInstance();
            }
            Object config = configFile == null ? new ConfigFile() : new ConfigFile(this.bundleContext.getBundle().getResource(configFile).toURI());
            try {
                Field spi = config.getClass().getDeclaredField("spi");
                boolean accessible = spi.isAccessible();
                spi.setAccessible(true);
                config = spi.get(config);
                spi.setAccessible(accessible);
            }
            catch (IllegalAccessException | NoSuchFieldException spi) {
                // empty catch block
            }
            Field f = config.getClass().getDeclaredField("configuration");
            boolean accessible = f.isAccessible();
            if (!accessible) {
                f.setAccessible(true);
            }
            try {
                configs = (HashMap)f.get(config);
            }
            finally {
                if (!accessible) {
                    f.setAccessible(accessible);
                }
            }
            if (configs == null) {
                throw new IllegalArgumentException("JAAS configuration is not available");
            }
            return configs;
        }
        catch (Exception e) {
            throw new IllegalStateException("JAAS configuration could not be loaded at this time", e);
        }
    }

    private JaasRealm createJaasRealm(final String realmName, final List<AppConfigurationEntry> entries) {
        return new JaasRealm(){

            public String getName() {
                return realmName;
            }

            public int getRank() {
                return 0;
            }

            public AppConfigurationEntry[] getEntries() {
                return entries.toArray(new AppConfigurationEntry[entries.size()]);
            }
        };
    }
}

