/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.orc.TypeDescription;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaConversionException;
import org.pentaho.di.core.row.value.ValueMetaConverter;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;

public class OrcConverter {
    private ValueMetaConverter valueMetaConverter = new ValueMetaConverter();
    private static final Logger logger = LogManager.getLogger(OrcConverter.class);

    public RowMetaAndData convertFromOrc(VectorizedRowBatch batch, int currentBatchRow, List<? extends IOrcInputField> dialogInputFields, TypeDescription typeDescription, Map<String, Integer> schemaToOrcSubcripts, List<? extends IOrcInputField> orcInputFields) {
        return this.convertFromOrc(new RowMetaAndData(), batch, currentBatchRow, dialogInputFields, typeDescription, schemaToOrcSubcripts, orcInputFields);
    }

    @VisibleForTesting
    RowMetaAndData convertFromOrc(RowMetaAndData rowMetaAndData, VectorizedRowBatch batch, int currentBatchRow, List<? extends IOrcInputField> dialogInputFields, TypeDescription typeDescription, Map<String, Integer> schemaToOrcSubcripts, List<? extends IOrcInputField> orcInputFields) {
        for (IOrcInputField iOrcInputField : dialogInputFields) {
            IOrcInputField orcField = this.getFormatField(iOrcInputField.getFormatFieldName(), orcInputFields);
            if (iOrcInputField == null) continue;
            ColumnVector columnVector = batch.cols[schemaToOrcSubcripts.get(iOrcInputField.getPentahoFieldName())];
            Object orcToPentahoValue = OrcConverter.convertFromSourceToTargetDataType(columnVector, currentBatchRow, orcField.getPentahoType());
            Object convertToSchemaValue = null;
            try {
                String dateFormatStr = iOrcInputField.getStringFormat();
                if (dateFormatStr == null || dateFormatStr.trim().length() == 0) {
                    dateFormatStr = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
                }
                this.valueMetaConverter.setDatePattern(new SimpleDateFormat(dateFormatStr));
                convertToSchemaValue = this.valueMetaConverter.convertFromSourceToTargetDataType(orcField.getPentahoType(), iOrcInputField.getPentahoType(), orcToPentahoValue);
            }
            catch (ValueMetaConversionException e) {
                logger.error((Object)e);
            }
            rowMetaAndData.addValue(iOrcInputField.getPentahoFieldName(), iOrcInputField.getPentahoType(), convertToSchemaValue);
            String stringFormat = iOrcInputField.getStringFormat();
            if (stringFormat == null || stringFormat.trim().length() <= 0) continue;
            rowMetaAndData.getValueMeta(rowMetaAndData.size() - 1).setConversionMask(stringFormat);
        }
        return rowMetaAndData;
    }

    protected static Object convertFromSourceToTargetDataType(ColumnVector columnVector, int currentBatchRow, int orcValueMetaInterface) {
        int indexToLookup;
        int n = indexToLookup = columnVector.isRepeating ? 0 : currentBatchRow;
        if (columnVector.isNull[indexToLookup]) {
            return null;
        }
        switch (orcValueMetaInterface) {
            case 10: {
                try {
                    return InetAddress.getByName(new String(((BytesColumnVector)columnVector).vector[indexToLookup], ((BytesColumnVector)columnVector).start[indexToLookup], ((BytesColumnVector)columnVector).length[indexToLookup]));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case 2: {
                return new String(((BytesColumnVector)columnVector).vector[indexToLookup], ((BytesColumnVector)columnVector).start[indexToLookup], ((BytesColumnVector)columnVector).length[indexToLookup]);
            }
            case 5: {
                return ((LongColumnVector)columnVector).vector[indexToLookup];
            }
            case 1: {
                return ((DoubleColumnVector)columnVector).vector[indexToLookup];
            }
            case 6: {
                HiveDecimalWritable obj = ((DecimalColumnVector)columnVector).vector[indexToLookup];
                return obj.getHiveDecimal().bigDecimalValue();
            }
            case 9: {
                Timestamp timestamp = new Timestamp(((TimestampColumnVector)columnVector).time[indexToLookup]);
                timestamp.setNanos(((TimestampColumnVector)columnVector).nanos[indexToLookup]);
                return timestamp;
            }
            case 3: {
                LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(((LongColumnVector)columnVector).vector[indexToLookup]);
                Date dateValue = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                return dateValue;
            }
            case 4: {
                return ((LongColumnVector)columnVector).vector[indexToLookup] != 0L;
            }
            case 8: {
                byte[] origBytes = ((BytesColumnVector)columnVector).vector[indexToLookup];
                int startPos = ((BytesColumnVector)columnVector).start[indexToLookup];
                byte[] newBytes = Arrays.copyOfRange(origBytes, startPos, startPos + ((BytesColumnVector)columnVector).length[indexToLookup]);
                return newBytes;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public IOrcInputField getFormatField(String formatFieldName, List<? extends IOrcInputField> fields) {
        if (formatFieldName == null || formatFieldName.trim().isEmpty()) {
            return null;
        }
        for (IOrcInputField iOrcInputField : fields) {
            if (!iOrcInputField.getFormatFieldName().equals(formatFieldName)) continue;
            return iOrcInputField;
        }
        return null;
    }
}

